/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.state.ProvisionedPackage;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisionedFeaturePack
implements FeaturePack<ProvisionedPackage> {
    private final FeaturePackLocation.FPID fpid;
    private final Map<String, ProvisionedPackage> packages;

    public static Builder builder(FeaturePackLocation.FPID fpid) {
        return new Builder(fpid);
    }

    public static ProvisionedFeaturePack forFPID(FeaturePackLocation.FPID fpid) {
        return new ProvisionedFeaturePack(fpid, Collections.emptyMap());
    }

    ProvisionedFeaturePack(FeaturePackLocation.FPID fpid, Map<String, ProvisionedPackage> packages) {
        this.fpid = fpid;
        this.packages = packages;
    }

    @Override
    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    @Override
    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    @Override
    public boolean containsPackage(String name) {
        return this.packages.containsKey(name);
    }

    @Override
    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    @Override
    public Collection<ProvisionedPackage> getPackages() {
        return this.packages.values();
    }

    @Override
    public ProvisionedPackage getPackage(String name) {
        return this.packages.get(name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fpid == null ? 0 : this.fpid.hashCode());
        result = 31 * result + (this.packages == null ? 0 : this.packages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedFeaturePack other = (ProvisionedFeaturePack)obj;
        if (this.fpid == null ? other.fpid != null : !this.fpid.equals((Object)other.fpid)) {
            return false;
        }
        return !(this.packages == null ? other.packages != null : !this.packages.equals(other.packages));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[').append(this.fpid);
        if (!this.packages.isEmpty()) {
            buf.append(' ');
            StringUtils.append((StringBuilder)buf, this.packages.values());
        }
        return buf.append(']').toString();
    }

    public static class Builder {
        private FeaturePackLocation.FPID fpid;
        private Map<String, ProvisionedPackage> packages = Collections.emptyMap();

        private Builder(FeaturePackLocation.FPID fpid) {
            this.fpid = fpid;
        }

        public Builder addPackage(String name) {
            return this.addPackage(ProvisionedPackage.newInstance(name));
        }

        public Builder addPackage(ProvisionedPackage provisionedPkg) {
            this.packages = CollectionUtils.putLinked(this.packages, (Object)provisionedPkg.getName(), (Object)provisionedPkg);
            return this;
        }

        public boolean hasPackage(String name) {
            return this.packages.containsKey(name);
        }

        public ProvisionedFeaturePack build() {
            return new ProvisionedFeaturePack(this.fpid, CollectionUtils.unmodifiable(this.packages));
        }
    }
}

