/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisionedState
implements FeaturePackSet<ProvisionedFeaturePack> {
    private final Map<FeaturePackLocation.ProducerSpec, ProvisionedFeaturePack> featurePacks;
    private final List<ProvisionedConfig> configs;

    public static Builder builder() {
        return new Builder();
    }

    ProvisionedState(Builder builder) {
        this.featurePacks = CollectionUtils.unmodifiable(builder.featurePacks);
        this.configs = CollectionUtils.unmodifiable(builder.configs);
    }

    @Override
    public boolean hasFeaturePacks() {
        return !this.featurePacks.isEmpty();
    }

    @Override
    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.featurePacks.containsKey(producer);
    }

    @Override
    public Collection<ProvisionedFeaturePack> getFeaturePacks() {
        return this.featurePacks.values();
    }

    @Override
    public ProvisionedFeaturePack getFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.featurePacks.get(producer);
    }

    @Override
    public boolean hasConfigs() {
        return !this.configs.isEmpty();
    }

    @Override
    public List<ProvisionedConfig> getConfigs() {
        return this.configs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.configs == null ? 0 : this.configs.hashCode());
        result = 31 * result + (this.featurePacks == null ? 0 : this.featurePacks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisionedState other = (ProvisionedState)obj;
        if (this.configs == null ? other.configs != null : this.configs.size() != other.configs.size() || !this.configs.containsAll(other.configs)) {
            return false;
        }
        if (this.featurePacks == null ? other.featurePacks != null : this.featurePacks.size() != other.featurePacks.size()) {
            return false;
        }
        Iterator<Map.Entry<FeaturePackLocation.ProducerSpec, ProvisionedFeaturePack>> i = this.featurePacks.entrySet().iterator();
        Iterator<Map.Entry<FeaturePackLocation.ProducerSpec, ProvisionedFeaturePack>> otherI = other.featurePacks.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().equals(otherI.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[state");
        if (!this.featurePacks.isEmpty()) {
            buf.append(" feature-packs=[");
            StringUtils.append((StringBuilder)buf, this.featurePacks.values());
            buf.append(']');
        }
        if (!this.configs.isEmpty()) {
            buf.append(" configs=[");
            StringUtils.append((StringBuilder)buf, this.configs);
            buf.append(']');
        }
        return buf.append(']').toString();
    }

    public static class Builder {
        private Map<FeaturePackLocation.ProducerSpec, ProvisionedFeaturePack> featurePacks = Collections.emptyMap();
        private List<ProvisionedConfig> configs = Collections.emptyList();

        private Builder() {
        }

        public Builder addFeaturePack(ProvisionedFeaturePack fp) {
            this.featurePacks = CollectionUtils.putLinked(this.featurePacks, (Object)fp.getFPID().getProducer(), (Object)fp);
            return this;
        }

        public Builder addConfig(ProvisionedConfig config) {
            this.configs = CollectionUtils.add(this.configs, (Object)config);
            return this;
        }

        public ProvisionedState build() {
            return new ProvisionedState(this);
        }
    }
}

