/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.galleon1;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Producer;
import org.jboss.galleon.util.CollectionUtils;

public class LegacyGalleon1Universe
implements Universe<LegacyGalleon1Producer> {
    private static final String ZIP = "zip";
    private static UniverseSpec universeSource;
    final RepositoryArtifactResolver artifactResolver;
    private Map<String, LegacyGalleon1Producer> producers = Collections.emptyMap();

    public static UniverseSpec getUniverseSpec() {
        if (universeSource == null) {
            universeSource = new UniverseSpec("galleon1", null);
        }
        return universeSource;
    }

    public static String toMavenCoords(FeaturePackLocation fpl) throws ProvisioningException {
        String producer = fpl.getProducerName();
        int colon = producer.indexOf(58);
        if (colon <= 0) {
            throw new ProvisioningException("Failed to determine group and artifact IDs for " + fpl);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(producer.substring(0, colon)).append(':').append(producer.substring(colon + 1)).append(':').append(ZIP);
        buf.append(':').append(fpl.getBuild());
        return buf.toString();
    }

    public static FeaturePackLocation toFpl(String groupId, String artifactId, String version) {
        if (version == null) {
            return new FeaturePackLocation(new UniverseSpec("galleon1", null), groupId + ":" + artifactId, null, null, version);
        }
        int i = version.indexOf(46);
        return new FeaturePackLocation(new UniverseSpec("galleon1", null), groupId + ":" + artifactId, i > 0 ? version.substring(0, i) : version, null, version);
    }

    public static FeaturePackLocation.FPID newFPID(String producer, String channel, String build) {
        return new FeaturePackLocation(LegacyGalleon1Universe.getUniverseSpec(), producer, channel, null, build).getFPID();
    }

    public static FeaturePackLocation.ProducerSpec newProducer(String producer) {
        return new FeaturePackLocation(new UniverseSpec("galleon1", null), producer, null, null, null).getProducer();
    }

    public LegacyGalleon1Universe(RepositoryArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public String getFactoryId() {
        return "galleon1";
    }

    public String getLocation() {
        return null;
    }

    public boolean hasProducer(String producerName) throws ProvisioningException {
        return true;
    }

    public LegacyGalleon1Producer getProducer(String producerName) throws ProvisioningException {
        LegacyGalleon1Producer producer = this.producers.get(producerName);
        if (producer == null) {
            producer = new LegacyGalleon1Producer(this, producerName);
            this.producers = CollectionUtils.put(this.producers, (Object)producerName, (Object)producer);
        }
        return producer;
    }

    public Collection<LegacyGalleon1Producer> getProducers() throws ProvisioningException {
        return this.producers.values();
    }
}

