/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class StateHistoryUtils {
    public static final int STATE_HISTORY_LIMIT = 100;

    public static void addNewUndoConfig(Path installDir, Path stagedDir, Map<String, Boolean> undoTasks, MessageWriter log) throws ProvisioningException {
        Path installHistoryList;
        Path installedConfig = PathsUtils.getProvisioningXml((Path)installDir);
        if (!Files.exists(installedConfig, new LinkOption[0])) {
            return;
        }
        Path stagedHistoryDir = PathsUtils.getStateHistoryDir((Path)stagedDir);
        StateHistoryUtils.mkdirs(stagedHistoryDir);
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryDir, new LinkOption[0]) && Files.exists(installHistoryList = installedHistoryDir.resolve("list"), new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installHistoryList), (Throwable)e);
            }
        }
        int historyLimit = installedHistory.isEmpty() ? 100 : Integer.parseInt((String)installedHistory.get(0));
        String newStateId = UUID.randomUUID().toString();
        try (BufferedWriter writer = Files.newBufferedWriter(stagedHistoryDir.resolve("list"), new OpenOption[0]);){
            writer.write(String.valueOf(historyLimit));
            writer.newLine();
            if (!installedHistory.isEmpty()) {
                int offset = installedHistory.size() - historyLimit + 1;
                if (offset < 1) {
                    offset = 1;
                }
                int missingStates = 0;
                while (offset < installedHistory.size()) {
                    String stateId;
                    Path stateFile;
                    if (!Files.exists(stateFile = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                        ++missingStates;
                        continue;
                    }
                    IoUtils.copy((Path)stateFile, (Path)stagedHistoryDir.resolve(stateId));
                    writer.write(stateId);
                    writer.newLine();
                }
                if (missingStates > 0) {
                    log.error((CharSequence)("The state history of the current installation is corrupted referencing " + missingStates + " missing states!"));
                }
            }
            if (historyLimit > 0) {
                writer.write(newStateId);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.writeFile((Path)stagedHistoryDir.resolve("list")), (Throwable)e);
        }
        Path stateDir = stagedHistoryDir.resolve(newStateId);
        try {
            Files.createDirectory(stateDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.mkdirs((Path)stateDir));
        }
        try {
            IoUtils.copy((Path)installedConfig, (Path)stateDir.resolve("provisioning.xml"));
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.copyFile((Path)installedConfig, (Path)stateDir.resolve("provisioning.xml")), (Throwable)e);
        }
        if (!undoTasks.isEmpty()) {
            log.verbose((CharSequence)"Persisting undo tasks: ");
            try (BufferedWriter writer = Files.newBufferedWriter(stateDir.resolve("undo.tasks"), new OpenOption[0]);){
                for (Map.Entry<String, Boolean> entry : undoTasks.entrySet()) {
                    String action = entry.getValue() != false ? "keep" : "remove";
                    log.verbose(" - %s %s", new Object[]{entry.getKey(), action});
                    writer.write(entry.getKey());
                    writer.newLine();
                    writer.write(action);
                    writer.newLine();
                }
            }
            catch (IOException e) {
                throw new ProvisioningException(BaseErrors.writeFile((Path)stateDir.resolve("undo.tasks")), (Throwable)e);
            }
        }
    }

    public static void removeLastUndoConfig(Path installDir, Path stagedDir, MessageWriter log) throws ProvisioningException {
        Path installHistoryList;
        Path installedConfig = PathsUtils.getProvisioningXml((Path)installDir);
        if (!Files.exists(installedConfig, new LinkOption[0])) {
            return;
        }
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryDir, new LinkOption[0]) && Files.exists(installHistoryList = installedHistoryDir.resolve("list"), new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installHistoryList), (Throwable)e);
            }
        }
        if (installedHistory.size() < 2) {
            return;
        }
        Path stagedHistoryDir = PathsUtils.getStateHistoryDir((Path)stagedDir);
        StateHistoryUtils.mkdirs(stagedHistoryDir);
        int historyLimit = installedHistory.isEmpty() ? 100 : Integer.parseInt((String)installedHistory.get(0));
        try (BufferedWriter writer = Files.newBufferedWriter(stagedHistoryDir.resolve("list"), new OpenOption[0]);){
            writer.write(String.valueOf(historyLimit));
            writer.newLine();
            if (!installedHistory.isEmpty()) {
                int offset = installedHistory.size() - historyLimit - 1;
                if (offset < 1) {
                    offset = 1;
                }
                int missingStates = 0;
                while (offset < installedHistory.size() - 1) {
                    String stateId;
                    Path stateDir;
                    if (!Files.exists(stateDir = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                        ++missingStates;
                        continue;
                    }
                    IoUtils.copy((Path)stateDir, (Path)stagedHistoryDir.resolve(stateId));
                    writer.write(stateId);
                    writer.newLine();
                }
                if (missingStates > 0) {
                    log.error((CharSequence)("The state history of the current installation is corrupted referencing " + missingStates + " missing states!"));
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.writeFile((Path)stagedHistoryDir.resolve("list")), (Throwable)e);
        }
    }

    private static void mkdirs(Path stagedHistoryDir) throws ProvisioningException {
        try {
            Files.createDirectories(stagedHistoryDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.mkdirs((Path)stagedHistoryDir), (Throwable)e);
        }
    }

    public static boolean isUndoAvailable(Path installDir, MessageWriter log) throws ProvisioningException {
        List<String> installedHistory;
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            return false;
        }
        Path installedHistoryList = PathsUtils.getStateHistoryFile((Path)installDir);
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            return false;
        }
        try {
            installedHistory = Files.readAllLines(installedHistoryList);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), (Throwable)e);
        }
        if (installedHistory.size() < 2) {
            return false;
        }
        int i = installedHistory.size() - 1;
        do {
            if (Files.exists(installedHistoryDir.resolve(installedHistory.get(i--)), new LinkOption[0])) {
                return true;
            }
            log.error((CharSequence)"The state history of the current installation is corrupted referencing missing states!");
        } while (i >= 1);
        return false;
    }

    public static Path getUndoStateDir(Path installDir, MessageWriter log) throws ProvisioningException {
        List<String> installedHistory;
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            return null;
        }
        Path installedHistoryList = installedHistoryDir.resolve("list");
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            return null;
        }
        try {
            installedHistory = Files.readAllLines(installedHistoryList);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), (Throwable)e);
        }
        if (installedHistory.size() < 2) {
            return null;
        }
        int i = installedHistory.size() - 1;
        do {
            Path statePath;
            if (Files.exists((statePath = installedHistoryDir.resolve(installedHistory.get(i--))).resolve("provisioning.xml"), new LinkOption[0])) {
                return statePath;
            }
            log.error((CharSequence)"The state history of the current installation is corrupted referencing missing states!");
        } while (i >= 1);
        return null;
    }

    public static ProvisioningConfig readUndoConfig(Path installDir, MessageWriter log) throws ProvisioningException {
        Path stateDir = StateHistoryUtils.getUndoStateDir(installDir, log);
        if (stateDir == null) {
            throw new ProvisioningException(Errors.historyIsEmpty());
        }
        return ProvisioningXmlParser.parse(stateDir.resolve("provisioning.xml"));
    }

    public static Map<String, Boolean> readUndoTasks(Path installDir, MessageWriter log) throws ProvisioningException {
        Path stateDir = StateHistoryUtils.getUndoStateDir(installDir, log);
        if (stateDir == null) {
            return Collections.emptyMap();
        }
        Path undoTasksFile = stateDir.resolve("undo.tasks");
        if (!Files.exists(undoTasksFile, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Boolean> tasks = new LinkedHashMap<String, Boolean>();
        try (BufferedReader reader = Files.newBufferedReader(undoTasksFile);){
            String line = reader.readLine();
            while (line != null) {
                String action = reader.readLine();
                if ("keep".equals(action)) {
                    tasks.put(line, true);
                } else if ("remove".equals(action)) {
                    tasks.put(line, false);
                } else {
                    throw new ProvisioningException("Unexpected undo task '" + action + "' for " + line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(undoTasksFile), (Throwable)e);
        }
        return tasks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readStateHistoryLimit(Path installDir, MessageWriter log) throws ProvisioningException {
        Path installedHistoryList = PathsUtils.getStateHistoryFile((Path)installDir);
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            return 100;
        }
        try (BufferedReader reader = Files.newBufferedReader(installedHistoryList);){
            String line = reader.readLine();
            if (line == null) return 100;
            int n = Integer.parseInt(line);
            return n;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), (Throwable)e);
        }
    }

    public static int writeStateHistoryLimit(Path installDir, int limit, MessageWriter log) throws ProvisioningException {
        if (limit < 0) {
            throw new ProvisioningException("State history limit can not be a negative value: " + limit);
        }
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            StateHistoryUtils.mkdirs(installedHistoryDir);
        }
        Path installedHistoryList = installedHistoryDir.resolve("list");
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryList, new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installedHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installedHistoryList), (Throwable)e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(installedHistoryList, new OpenOption[0]);){
            writer.write(String.valueOf(limit));
            writer.newLine();
            int offset = installedHistory.size() - limit;
            if (offset < 1) {
                offset = 1;
            }
            int missingStates = 0;
            while (offset < installedHistory.size()) {
                String stateId;
                Path stateFile;
                if (!Files.exists(stateFile = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                    ++missingStates;
                    continue;
                }
                writer.write(stateId);
                writer.newLine();
            }
            if (missingStates > 0) {
                log.error((CharSequence)("The state history of the current installation is corrupted referencing " + missingStates + " missing states!"));
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), (Throwable)e);
        }
        return 100;
    }

    public static void clearStateHistory(Path installDir, MessageWriter log) throws ProvisioningException {
        Path installedHistoryDir = PathsUtils.getStateHistoryDir((Path)installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            return;
        }
        int limit = StateHistoryUtils.readStateHistoryLimit(installDir, log);
        Path installedHistoryList = installedHistoryDir.resolve("list");
        try (BufferedWriter writer = Files.newBufferedWriter(installedHistoryList, new OpenOption[0]);){
            writer.write(String.valueOf(limit));
            writer.newLine();
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.writeFile((Path)installedHistoryList), (Throwable)e);
        }
        StateHistoryUtils.deleteHistoryFiles(installedHistoryDir);
    }

    private static void deleteHistoryFiles(Path installedHistoryDir) throws ProvisioningException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(installedHistoryDir);){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                IoUtils.recursiveDelete((Path)entry);
            }
        }
        catch (IOException ex) {
            throw new ProvisioningException(BaseErrors.readDirectory((Path)installedHistoryDir), (Throwable)ex);
        }
    }
}

