/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.formatparser.DefaultContentHandlerFactory;
import org.jboss.galleon.util.formatparser.FormatContentHandler;
import org.jboss.galleon.util.formatparser.FormatContentHandlerFactory;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingFormat;

public class ExtendedContentHandlerFactory
implements FormatContentHandlerFactory {
    private static final Class<?>[] CH_CTOR_ARGS = new Class[]{ParsingFormat.class, Integer.TYPE};
    private final FormatContentHandlerFactory delegate;
    private Map<String, Class<? extends FormatContentHandler>> chTypes = Collections.emptyMap();

    public static ExtendedContentHandlerFactory getInstance() {
        return new ExtendedContentHandlerFactory(DefaultContentHandlerFactory.getInstance());
    }

    public static ExtendedContentHandlerFactory getInstance(FormatContentHandlerFactory delegate) {
        return new ExtendedContentHandlerFactory(delegate);
    }

    private ExtendedContentHandlerFactory(FormatContentHandlerFactory delegate) {
        this.delegate = delegate;
    }

    public ExtendedContentHandlerFactory addContentHandler(String formatName, Class<? extends FormatContentHandler> cls) {
        this.chTypes = CollectionUtils.put(this.chTypes, (Object)formatName, cls);
        return this;
    }

    @Override
    public FormatContentHandler forFormat(ParsingFormat format, int strIndex) throws FormatParsingException {
        Class<? extends FormatContentHandler> chClass = this.chTypes.get(format.getContentType());
        if (chClass == null) {
            return this.delegate.forFormat(format, strIndex);
        }
        try {
            Constructor<? extends FormatContentHandler> ctor = chClass.getConstructor(CH_CTOR_ARGS);
            return ctor.newInstance(format, strIndex);
        }
        catch (Exception e) {
            throw new FormatParsingException("Failed to instantiate content handler " + chClass.getName() + " for format " + format, e);
        }
    }
}

