/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util.formatparser.formats;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.formatparser.FormatErrors;
import org.jboss.galleon.util.formatparser.FormatParsingException;
import org.jboss.galleon.util.formatparser.ParsingContext;
import org.jboss.galleon.util.formatparser.ParsingFormat;
import org.jboss.galleon.util.formatparser.formats.KeyValueParsingFormat;
import org.jboss.galleon.util.formatparser.formats.ObjectParsingFormat;

public class CompositeParsingFormat
extends ObjectParsingFormat {
    private boolean acceptAll = false;
    private Map<String, ParsingFormat> elems = Collections.emptyMap();

    public static CompositeParsingFormat newInstance() {
        return CompositeParsingFormat.newInstance(null);
    }

    public static CompositeParsingFormat newInstance(String name) {
        return new CompositeParsingFormat(name == null ? "Object" : name);
    }

    public static CompositeParsingFormat newInstance(String name, String contentType) {
        return new CompositeParsingFormat(name == null ? "Object" : name, contentType);
    }

    public static CompositeParsingFormat newInstance(String name, KeyValueParsingFormat entryFormat) {
        return new CompositeParsingFormat(name == null ? "Object" : name, entryFormat);
    }

    public static CompositeParsingFormat newInstance(String name, String contentType, KeyValueParsingFormat entryFormat) {
        return new CompositeParsingFormat(name == null ? "Object" : name, contentType, entryFormat);
    }

    protected CompositeParsingFormat(String name) {
        super(name);
    }

    protected CompositeParsingFormat(String name, String contentType) {
        super(name, contentType);
    }

    protected CompositeParsingFormat(String name, KeyValueParsingFormat entryFormat) {
        super(name, entryFormat);
    }

    protected CompositeParsingFormat(String name, String contentType, KeyValueParsingFormat entryFormat) {
        super(name, contentType, entryFormat);
    }

    public CompositeParsingFormat setAcceptAll(boolean acceptAll) {
        this.acceptAll = acceptAll;
        return this;
    }

    public CompositeParsingFormat addElement(String name) {
        return this.addElement(name, this.entryFormat);
    }

    public CompositeParsingFormat addElement(String name, ParsingFormat valueFormat) {
        this.elems = CollectionUtils.put(this.elems, (Object)name, (Object)(valueFormat == null ? this.entryFormat : KeyValueParsingFormat.newInstance(this.entryFormat.getKeyFormat(), this.entryFormat.getSeparator(), valueFormat)));
        return this;
    }

    @Override
    public boolean isAcceptsKey(Object name) {
        return this.acceptAll || this.elems.containsKey(name);
    }

    @Override
    public void deal(ParsingContext ctx) throws FormatParsingException {
        if (Character.isWhitespace(ctx.charNow())) {
            return;
        }
        Map.Entry<String, ParsingFormat> matchedElem = null;
        for (Map.Entry<String, ParsingFormat> elem : this.elems.entrySet()) {
            if (!ctx.startsNow(elem.getKey())) continue;
            if (matchedElem == null) {
                matchedElem = elem;
                continue;
            }
            if (matchedElem.getKey().length() >= elem.getKey().length()) continue;
            matchedElem = elem;
        }
        ParsingFormat valueFormat = null;
        if (matchedElem == null) {
            if (!this.acceptAll) {
                throw new FormatParsingException(FormatErrors.unexpectedCompositeFormatElement(this, null));
            }
            valueFormat = this.entryFormat;
        } else {
            valueFormat = (ParsingFormat)matchedElem.getValue();
        }
        ctx.pushFormat(valueFormat);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.acceptAll ? 1231 : 1237);
        result = 31 * result + (this.elems == null ? 0 : this.elems.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeParsingFormat other = (CompositeParsingFormat)obj;
        if (this.acceptAll != other.acceptAll) {
            return false;
        }
        return !(this.elems == null ? other.elems != null : !this.elems.equals(other.elems));
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (this.name != null) {
            buf.append("!name:").append(this.name);
        }
        if (this.contentType != null) {
            buf.append("!content-type:").append(this.contentType);
        }
        if (!this.elems.isEmpty()) {
            Iterator<Map.Entry<String, ParsingFormat>> i = this.elems.entrySet().iterator();
            Map.Entry<String, ParsingFormat> elem = i.next();
            buf.append(elem.getKey()).append(':').append(((KeyValueParsingFormat)elem.getValue()).getValueFormat());
            while (i.hasNext()) {
                elem = i.next();
                buf.append(',').append(elem.getKey()).append(':').append(((KeyValueParsingFormat)elem.getValue()).getValueFormat());
            }
        }
        return buf.append('}').toString();
    }
}

