/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.xml.XmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class ConfigXmlParser
implements XmlParser<ConfigModel> {
    private static final ConfigXmlParser INSTANCE = new ConfigXmlParser();

    public static ConfigXmlParser getInstance() {
        return INSTANCE;
    }

    public static ConfigModel parse(Path p) throws ProvisioningException {
        ConfigModel configModel;
        block8: {
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                configModel = INSTANCE.parse(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningException(Errors.parseXml(p), (Throwable)e);
                }
            }
            reader.close();
        }
        return configModel;
    }

    private ConfigXmlParser() {
    }

    @Override
    public ConfigModel parse(Reader input) throws XMLStreamException, ProvisioningDescriptionException {
        ConfigModel.Builder builder = ConfigModel.builder();
        XmlParsers.parse(input, builder);
        return builder.build();
    }
}

