/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXml;
import org.jboss.galleon.xml.FeatureGroupXmlWriter;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class ConfigXmlWriter
extends BaseXmlWriter<ConfigModel> {
    private static final ConfigXmlWriter INSTANCE = new ConfigXmlWriter();

    public static ConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ConfigXmlWriter() {
    }

    protected ElementNode toElement(ConfigModel config) {
        return this.toElement(config, "urn:jboss:galleon:config:1.0");
    }

    protected ElementNode toElement(ConfigModel config, String ns) {
        ElementNode layer;
        ElementNode configE = ConfigXmlWriter.addElement(null, (String)ConfigXml.Element.CONFIG.getLocalName(), (String)ns);
        if (config.getModel() != null) {
            ConfigXmlWriter.addAttribute((ElementNode)configE, (XmlNameProvider)ConfigXml.Attribute.MODEL, (String)config.getModel());
        }
        if (config.hasProperties()) {
            ElementNode propsE = ConfigXmlWriter.addElement((ElementNode)configE, (String)ConfigXml.Element.PROPS.getLocalName(), (String)ns);
            for (Map.Entry<String, String> entry : config.getProperties().entrySet()) {
                ElementNode propE = ConfigXmlWriter.addElement((ElementNode)propsE, (String)ConfigXml.Element.PROP.getLocalName(), (String)ns);
                ConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ConfigXml.Attribute.NAME, (String)entry.getKey());
                ConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ConfigXml.Attribute.VALUE, (String)entry.getValue());
            }
        }
        if (config.hasConfigDeps()) {
            ElementNode configDeps = ConfigXmlWriter.addElement((ElementNode)configE, (String)ConfigXml.Element.CONFIG_DEPS.getLocalName(), (String)ns);
            for (Map.Entry entry : config.getConfigDeps().entrySet()) {
                ElementNode configDep = ConfigXmlWriter.addElement((ElementNode)configDeps, (String)ConfigXml.Element.CONFIG_DEP.getLocalName(), (String)ns);
                ConfigXmlWriter.addAttribute((ElementNode)configDep, (String)ConfigXml.Attribute.ID.getLocalName(), (String)((String)entry.getKey()));
                ConfigId configId = (ConfigId)entry.getValue();
                if (configId.getModel() != null) {
                    ConfigXmlWriter.addAttribute((ElementNode)configDep, (String)ConfigXml.Attribute.MODEL.getLocalName(), (String)configId.getModel());
                }
                if (configId.getName() == null) continue;
                ConfigXmlWriter.addAttribute((ElementNode)configDep, (String)ConfigXml.Attribute.NAME.getLocalName(), (String)configId.getName());
            }
        }
        ElementNode layers = null;
        if (!config.isInheritLayers()) {
            layers = ConfigXmlWriter.addElement((ElementNode)configE, (String)ConfigXml.Element.LAYERS.getLocalName(), (String)ns);
            ConfigXmlWriter.addAttribute((ElementNode)layers, (XmlNameProvider)ConfigXml.Attribute.INHERIT, (String)"false");
        }
        if (config.hasIncludedLayers()) {
            if (layers == null) {
                layers = ConfigXmlWriter.addElement((ElementNode)configE, (String)ConfigXml.Element.LAYERS.getLocalName(), (String)ns);
            }
            for (String string : config.getIncludedLayers()) {
                layer = ConfigXmlWriter.addElement((ElementNode)layers, (String)ConfigXml.Element.INCLUDE.getLocalName(), (String)ns);
                ConfigXmlWriter.addAttribute((ElementNode)layer, (XmlNameProvider)ConfigXml.Attribute.NAME, (String)string);
            }
        }
        if (config.hasExcludedLayers()) {
            if (layers == null) {
                layers = ConfigXmlWriter.addElement((ElementNode)configE, (String)ConfigXml.Element.LAYERS.getLocalName(), (String)ns);
            }
            for (String string : config.getExcludedLayers()) {
                layer = ConfigXmlWriter.addElement((ElementNode)layers, (String)ConfigXml.Element.EXCLUDE.getLocalName(), (String)ns);
                ConfigXmlWriter.addAttribute((ElementNode)layer, (XmlNameProvider)ConfigXml.Attribute.NAME, (String)string);
            }
        }
        FeatureGroupXmlWriter.addFeatureGroupDepBody(config, configE, ns);
        return configE;
    }
}

