/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class FeatureGroupXmlWriter
extends BaseXmlWriter<FeatureGroup> {
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final FeatureGroupXmlWriter INSTANCE = new FeatureGroupXmlWriter();

    public static FeatureGroupXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeatureGroupXmlWriter() {
    }

    protected ElementNode toElement(FeatureGroup config) {
        return this.toElement(config, "urn:jboss:galleon:feature-group:1.0");
    }

    protected ElementNode toElement(FeatureGroup featureGroup, String ns) {
        ElementNode fgE = FeatureGroupXmlWriter.addElement(null, (String)FeatureGroupXml.Element.FEATURE_GROUP_SPEC.getLocalName(), (String)ns);
        if (featureGroup.getName() != null) {
            FeatureGroupXmlWriter.addAttribute((ElementNode)fgE, (XmlNameProvider)FeatureGroupXml.Attribute.NAME, (String)featureGroup.getName());
        }
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(fgE, featureGroup, ns);
        if (featureGroup.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(featureGroup, FeatureGroupXmlWriter.addElement((ElementNode)fgE, (String)FeatureGroupXml.Element.PACKAGES.getLocalName(), (String)ns));
        }
        return fgE;
    }

    static void writeFeatureGroupSpecBody(ElementNode configE, ConfigItemContainer featureGroup, String ns) {
        if (!featureGroup.hasItems()) {
            return;
        }
        String currentOrigin = null;
        ElementNode parent = configE;
        for (ConfigItem item : featureGroup.getItems()) {
            String itemOrigin = item.getOrigin();
            if (itemOrigin != null) {
                if (!itemOrigin.equals(currentOrigin)) {
                    parent = FeatureGroupXmlWriter.addElement((ElementNode)configE, (String)FeatureGroupXml.Element.ORIGIN.getLocalName(), (String)ns);
                    FeatureGroupXmlWriter.addAttribute((ElementNode)parent, (XmlNameProvider)FeatureGroupXml.Attribute.NAME, (String)itemOrigin);
                    currentOrigin = itemOrigin;
                }
            } else if (currentOrigin != null) {
                currentOrigin = null;
                parent = configE;
            }
            if (item.isGroup()) {
                FeatureGroupXmlWriter.writeFeatureGroupDependency(parent, (FeatureGroup)item, ns);
                continue;
            }
            FeatureGroupXmlWriter.addFeatureConfig(parent, (FeatureConfig)item, ns);
        }
    }

    private static void writeFeatureGroupDependency(ElementNode depsE, FeatureGroup dep, String ns) {
        ElementNode depE = FeatureGroupXmlWriter.addElement((ElementNode)depsE, (String)FeatureGroupXml.Element.FEATURE_GROUP.getLocalName(), (String)ns);
        FeatureGroupXmlWriter.addFeatureGroupDepBody(dep, depE, ns);
    }

    public static void addFeatureGroupDepBody(FeatureGroupSupport dep, ElementNode depE, String ns) {
        if (dep.getName() != null) {
            FeatureGroupXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureGroupXml.Attribute.NAME, (String)dep.getName());
        }
        if (!dep.isInheritFeatures()) {
            FeatureGroupXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureGroupXml.Attribute.INHERIT_FEATURES, (String)FALSE);
        }
        FeatureGroupXmlWriter.addFeatureGroupIncludeExclude(dep, ns, depE);
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(depE, dep, ns);
        if (dep.hasExternalFeatureGroups()) {
            for (Map.Entry<String, FeatureGroup> entry : dep.getExternalFeatureGroups().entrySet()) {
                ElementNode fpE = FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.ORIGIN.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)fpE, (XmlNameProvider)FeatureGroupXml.Attribute.NAME, (String)entry.getKey());
                FeatureGroupXmlWriter.addFeatureGroupIncludeExclude(entry.getValue(), ns, fpE);
            }
        }
        if (dep.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(dep, FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.PACKAGES.getLocalName(), (String)ns));
        }
    }

    static void addFeatureGroupIncludeExclude(FeatureGroupSupport dep, String ns, ElementNode depE) {
        ElementNode includeE;
        ElementNode excludeE;
        if (dep.hasExcludedSpecs()) {
            for (SpecId specId : dep.getExcludedSpecs()) {
                excludeE = FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.EXCLUDE.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)excludeE, (XmlNameProvider)FeatureGroupXml.Attribute.SPEC, (String)specId.toString());
            }
        }
        if (dep.hasExcludedFeatures()) {
            for (Map.Entry entry : dep.getExcludedFeatures().entrySet()) {
                excludeE = FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.EXCLUDE.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)excludeE, (XmlNameProvider)FeatureGroupXml.Attribute.FEATURE_ID, (String)((FeatureId)entry.getKey()).toString());
                if (entry.getValue() == null) continue;
                FeatureGroupXmlWriter.addAttribute((ElementNode)excludeE, (XmlNameProvider)FeatureGroupXml.Attribute.PARENT_REF, (String)((String)entry.getValue()));
            }
        }
        if (dep.hasIncludedSpecs()) {
            for (SpecId specId : dep.getIncludedSpecs()) {
                includeE = FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.INCLUDE.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)includeE, (XmlNameProvider)FeatureGroupXml.Attribute.SPEC, (String)specId.toString());
            }
        }
        if (dep.hasIncludedFeatures()) {
            for (Map.Entry entry : dep.getIncludedFeatures().entrySet()) {
                includeE = FeatureGroupXmlWriter.addElement((ElementNode)depE, (String)FeatureGroupXml.Element.INCLUDE.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)includeE, (XmlNameProvider)FeatureGroupXml.Attribute.FEATURE_ID, (String)((FeatureId)entry.getKey()).toString());
                FeatureConfig fc = (FeatureConfig)entry.getValue();
                if (fc.getParentRef() != null) {
                    FeatureGroupXmlWriter.addAttribute((ElementNode)includeE, (XmlNameProvider)FeatureGroupXml.Attribute.PARENT_REF, (String)fc.getParentRef());
                }
                if (fc == null) continue;
                FeatureGroupXmlWriter.addFeatureConfigBody(includeE, (FeatureId)entry.getKey(), fc, ns);
            }
        }
    }

    private static void addFeatureConfigBody(ElementNode fcE, FeatureId id, FeatureConfig fc, String ns) {
        ElementNode paramE;
        if (fc.hasFeatureDeps()) {
            for (FeatureDependencySpec featureDependencySpec : fc.getFeatureDeps()) {
                ElementNode depE = FeatureGroupXmlWriter.addElement((ElementNode)fcE, (String)FeatureGroupXml.Element.DEPENDS.getLocalName(), (String)ns);
                if (featureDependencySpec.getOrigin() != null) {
                    FeatureGroupXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureGroupXml.Attribute.ORIGIN, (String)featureDependencySpec.getOrigin());
                }
                FeatureGroupXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureGroupXml.Attribute.FEATURE_ID, (String)featureDependencySpec.getFeatureId().toString());
                if (!featureDependencySpec.isInclude()) continue;
                FeatureGroupXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureGroupXml.Attribute.INCLUDE, (String)TRUE);
            }
        }
        if (fc.hasParams()) {
            for (Map.Entry entry : fc.getParams().entrySet()) {
                String name = (String)entry.getKey();
                if (id != null && id.hasParam(name)) continue;
                ElementNode paramE2 = FeatureGroupXmlWriter.addElement((ElementNode)fcE, (String)FeatureGroupXml.Element.PARAM.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)paramE2, (XmlNameProvider)FeatureGroupXml.Attribute.NAME, (String)name);
                FeatureGroupXmlWriter.addAttribute((ElementNode)paramE2, (XmlNameProvider)FeatureGroupXml.Attribute.VALUE, (String)((String)entry.getValue()));
            }
        }
        if (fc.hasResetParams()) {
            for (String string : fc.getResetParams()) {
                paramE = FeatureGroupXmlWriter.addElement((ElementNode)fcE, (String)FeatureGroupXml.Element.RESET_PARAM.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureGroupXml.Attribute.PARAM, (String)string);
            }
        }
        if (fc.hasUnsetParams()) {
            for (String string : fc.getUnsetParams()) {
                paramE = FeatureGroupXmlWriter.addElement((ElementNode)fcE, (String)FeatureGroupXml.Element.UNSET_PARAM.getLocalName(), (String)ns);
                FeatureGroupXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureGroupXml.Attribute.PARAM, (String)string);
            }
        }
        FeatureGroupXmlWriter.writeFeatureGroupSpecBody(fcE, fc, ns);
    }

    public static void addFeatureConfig(ElementNode parentE, FeatureConfig fc, String ns) {
        ElementNode fcE = FeatureGroupXmlWriter.addElement((ElementNode)parentE, (String)FeatureGroupXml.Element.FEATURE.getLocalName(), (String)ns);
        FeatureGroupXmlWriter.addAttribute((ElementNode)fcE, (XmlNameProvider)FeatureGroupXml.Attribute.SPEC, (String)fc.getSpecId().toString());
        if (fc.getParentRef() != null) {
            FeatureGroupXmlWriter.addAttribute((ElementNode)fcE, (XmlNameProvider)FeatureGroupXml.Attribute.PARENT_REF, (String)fc.getParentRef());
        }
        FeatureGroupXmlWriter.addFeatureConfigBody(fcE, null, fc, ns);
    }
}

