/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;

public class FeaturePackPackagesConfigParser10 {
    private static final String EXCLUDE = "exclude";
    private static final String INCLUDE = "include";
    private static final String INHERIT = "inherit";
    private static final String NAME = "name";

    public static void readPackages(XMLStreamReader reader, FeaturePackConfig.Builder builder) throws XMLStreamException, ProvisioningDescriptionException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!reader.getAttributeLocalName(i).equals(INHERIT)) {
                throw ParsingUtils.unexpectedContent(reader);
            }
            builder.setInheritPackages(Boolean.parseBoolean(reader.getAttributeValue(i)));
        }
        block5: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    String localName = reader.getLocalName();
                    if (EXCLUDE.equals(localName)) {
                        builder.excludePackage(FeaturePackPackagesConfigParser10.parseName(reader));
                        continue block5;
                    }
                    if (INCLUDE.equals(localName)) {
                        builder.includePackage(FeaturePackPackagesConfigParser10.parseInclude(reader));
                        continue block5;
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static String parseInclude(XMLStreamReader reader) throws XMLStreamException {
        String name = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            if (!reader.getAttributeName(i).getLocalPart().equals(NAME)) {
                throw ParsingUtils.unexpectedContent(reader);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(new XmlNameProvider(){

                public String getNamespace() {
                    return "";
                }

                public String getLocalName() {
                    return FeaturePackPackagesConfigParser10.NAME;
                }
            }));
        }
        ParsingUtils.parseNoContent(reader);
        return name;
    }

    private static String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        for (int i = 0; i < count; ++i) {
            String localName = reader.getAttributeLocalName(i);
            if (!localName.equals(NAME)) {
                throw ParsingUtils.unexpectedContent(reader);
            }
            name = reader.getAttributeValue(i);
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(new XmlNameProvider(){

                public String getNamespace() {
                    return null;
                }

                public String getLocalName() {
                    return FeaturePackPackagesConfigParser10.NAME;
                }
            }));
        }
        ParsingUtils.parseNoContent(reader);
        return name;
    }
}

