/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import org.jboss.galleon.CoreVersion;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeaturePackXmlParser30;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class FeaturePackXmlWriter
extends BaseXmlWriter<FeaturePackSpec> {
    private static final FeaturePackXmlWriter INSTANCE = new FeaturePackXmlWriter();

    public static FeaturePackXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeaturePackXmlWriter() {
    }

    protected ElementNode toElement(FeaturePackSpec fpSpec) {
        ElementNode depElement;
        ElementNode fp = FeaturePackXmlWriter.addElement(null, (XmlNameProvider)FeaturePackXmlParser30.Element.FEATURE_PACK);
        FeaturePackXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Attribute.LOCATION, (String)fpSpec.getFPID().toString());
        FeaturePackXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Attribute.GALLEON_MIN_VERSION, (String)CoreVersion.getVersion());
        if (fpSpec.getConfigStability() != null) {
            FeaturePackXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Attribute.CONFIG_STABILITY_LEVEL, (String)fpSpec.getConfigStability().toString());
        }
        if (fpSpec.getPackageStability() != null) {
            FeaturePackXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Attribute.PACKAGE_STABILITY_LEVEL, (String)fpSpec.getPackageStability().toString());
        }
        ProvisioningXmlWriter.writeUniverseSpecs(fpSpec, fp);
        if (fpSpec.isPatch()) {
            ElementNode patchFor = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.PATCH);
            FeaturePackXmlWriter.addAttribute((ElementNode)patchFor, (XmlNameProvider)FeaturePackXmlParser30.Attribute.FOR, (String)fpSpec.getPatchFor().toString());
        }
        if (fpSpec.hasTransitiveDeps()) {
            ElementNode transitives = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.TRANSITIVE);
            for (FeaturePackConfig featurePackConfig : fpSpec.getTransitiveDeps()) {
                depElement = FeaturePackXmlWriter.addElement((ElementNode)transitives, (XmlNameProvider)FeaturePackXmlParser30.Element.DEPENDENCY);
                ProvisioningXmlWriter.writeFeaturePackConfig(depElement, fpSpec.getUserConfiguredLocation(featurePackConfig.getLocation()), featurePackConfig, fpSpec.originOf(featurePackConfig.getLocation().getProducer()));
            }
        }
        if (fpSpec.hasFeaturePackDeps()) {
            ElementNode deps = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.DEPENDENCIES);
            for (FeaturePackConfig featurePackConfig : fpSpec.getFeaturePackDeps()) {
                depElement = FeaturePackXmlWriter.addElement((ElementNode)deps, (XmlNameProvider)FeaturePackXmlParser30.Element.DEPENDENCY);
                ProvisioningXmlWriter.writeFeaturePackConfig(depElement, fpSpec.getUserConfiguredLocation(featurePackConfig.getLocation()), featurePackConfig, fpSpec.originOf(featurePackConfig.getLocation().getProducer()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, FeaturePackXmlParser30.Element.FEATURE_PACK.getNamespace(), fpSpec);
        if (fpSpec.hasDefaultPackages()) {
            ElementNode pkgs = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.DEFAULT_PACKAGES);
            Object[] pkgNames = fpSpec.getDefaultPackageNames().toArray(new String[0]);
            Arrays.sort(pkgNames);
            for (Object name : pkgNames) {
                FeaturePackXmlWriter.addAttribute((ElementNode)FeaturePackXmlWriter.addElement((ElementNode)pkgs, (XmlNameProvider)FeaturePackXmlParser30.Element.PACKAGE), (XmlNameProvider)FeaturePackXmlParser30.Attribute.NAME, (String)name);
            }
        }
        if (fpSpec.hasPlugins()) {
            ElementNode plugins = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.PLUGINS);
            for (FeaturePackPlugin featurePackPlugin : fpSpec.getPlugins().values()) {
                ElementNode pluginE = FeaturePackXmlWriter.addElement((ElementNode)plugins, (XmlNameProvider)FeaturePackXmlParser30.Element.PLUGIN);
                FeaturePackXmlWriter.addAttribute((ElementNode)pluginE, (XmlNameProvider)FeaturePackXmlParser30.Attribute.ID, (String)featurePackPlugin.getId());
                FeaturePackXmlWriter.addAttribute((ElementNode)pluginE, (XmlNameProvider)FeaturePackXmlParser30.Attribute.LOCATION, (String)featurePackPlugin.getLocation());
            }
        }
        if (fpSpec.hasSystemPaths()) {
            ElementNode systemPaths = FeaturePackXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)FeaturePackXmlParser30.Element.SYSTEM_PATHS);
            for (String string : fpSpec.getSystemPaths()) {
                ElementNode depElement2 = FeaturePackXmlWriter.addElement((ElementNode)systemPaths, (XmlNameProvider)FeaturePackXmlParser30.Element.SYSTEM_PATH);
                FeaturePackXmlWriter.addAttribute((ElementNode)depElement2, (XmlNameProvider)FeaturePackXmlParser30.Attribute.PATH, (String)string);
            }
        }
        return fp;
    }
}

