/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import java.util.Set;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeatureSpecXmlParser20;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class FeatureSpecXmlWriter
extends BaseXmlWriter<FeatureSpec> {
    private static final String TRUE = "true";
    private static final FeatureSpecXmlWriter INSTANCE = new FeatureSpecXmlWriter();

    public static FeatureSpecXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeatureSpecXmlWriter() {
    }

    protected ElementNode toElement(FeatureSpec featureSpec) {
        ElementNode specE = FeatureSpecXmlWriter.addElement(null, (XmlNameProvider)FeatureSpecXmlParser20.Element.FEATURE_SPEC);
        FeatureSpecXmlWriter.addAttribute((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)featureSpec.getName());
        if (featureSpec.getStability() != null) {
            FeatureSpecXmlWriter.addAttribute((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.STABILITY, (String)featureSpec.getStability().toString());
        }
        if (featureSpec.hasAnnotations()) {
            for (FeatureAnnotation fa : featureSpec.getAnnotations()) {
                ElementNode annotationE = FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.ANNOTATION);
                FeatureSpecXmlWriter.addAttribute((ElementNode)annotationE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)fa.getName());
                if (!fa.hasElements()) continue;
                for (Map.Entry<String, String> entry : fa.getElements().entrySet()) {
                    ElementNode elemE = FeatureSpecXmlWriter.addElement((ElementNode)annotationE, (XmlNameProvider)FeatureSpecXmlParser20.Element.ELEM);
                    FeatureSpecXmlWriter.addAttribute((ElementNode)elemE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)entry.getKey());
                    if (entry.getValue() == null) continue;
                    FeatureSpecXmlWriter.addAttribute((ElementNode)elemE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.VALUE, (String)entry.getValue());
                }
            }
        }
        if (featureSpec.providesCapabilities()) {
            this.writeCaps(FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.PROVIDES), featureSpec.getProvidedCapabilities());
        }
        if (featureSpec.requiresCapabilities()) {
            this.writeCaps(FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.REQUIRES), featureSpec.getRequiredCapabilities());
        }
        if (featureSpec.hasFeatureDeps()) {
            ElementNode depsE = FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.DEPENDENCIES);
            for (FeatureDependencySpec dep : featureSpec.getFeatureDeps()) {
                ElementNode depE = FeatureSpecXmlWriter.addElement((ElementNode)depsE, (XmlNameProvider)FeatureSpecXmlParser20.Element.DEPENDENCY);
                FeatureSpecXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.FEATURE_ID, (String)dep.getFeatureId().toString());
                if (dep.getOrigin() != null) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.DEPENDENCY, (String)dep.getOrigin());
                }
                if (!dep.isInclude()) continue;
                FeatureSpecXmlWriter.addAttribute((ElementNode)depE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.INCLUDE, (String)TRUE);
            }
        }
        if (featureSpec.hasFeatureRefs()) {
            ElementNode refsE = FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.REFERENCES);
            for (FeatureReferenceSpec ref : featureSpec.getFeatureRefs()) {
                ElementNode refE = FeatureSpecXmlWriter.addElement((ElementNode)refsE, (XmlNameProvider)FeatureSpecXmlParser20.Element.REFERENCE);
                String feature = ref.getFeature().toString();
                if (ref.getOrigin() != null) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.DEPENDENCY, (String)ref.getOrigin());
                }
                FeatureSpecXmlWriter.addAttribute((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.FEATURE, (String)feature);
                if (!feature.equals(ref.getName())) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)ref.getName());
                }
                if (ref.isNillable()) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NILLABLE, (String)TRUE);
                }
                if (ref.isInclude()) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.INCLUDE, (String)TRUE);
                }
                for (Map.Entry<String, String> mapping : ref.getMappedParams().entrySet()) {
                    ElementNode paramE = FeatureSpecXmlWriter.addElement((ElementNode)refE, (XmlNameProvider)FeatureSpecXmlParser20.Element.PARAMETER);
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)mapping.getKey());
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.MAPS_TO, (String)mapping.getValue());
                }
            }
        }
        if (featureSpec.hasParams()) {
            ElementNode paramsE = FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.PARAMETERS);
            for (FeatureParameterSpec paramSpec : featureSpec.getParams().values()) {
                ElementNode paramE = FeatureSpecXmlWriter.addElement((ElementNode)paramsE, (XmlNameProvider)FeatureSpecXmlParser20.Element.PARAMETER);
                FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)paramSpec.getName());
                if (paramSpec.isFeatureId()) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.FEATURE_ID, (String)TRUE);
                } else if (paramSpec.isNillable()) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NILLABLE, (String)TRUE);
                }
                if (paramSpec.hasDefaultValue()) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.DEFAULT, (String)paramSpec.getDefaultValue());
                }
                if (paramSpec.getType() != null && !"String".equals(paramSpec.getType())) {
                    FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.TYPE, (String)paramSpec.getType());
                }
                if (paramSpec.getStability() == null) continue;
                FeatureSpecXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.STABILITY, (String)paramSpec.getStability().toString());
            }
        }
        if (featureSpec.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(featureSpec, FeatureSpecXmlWriter.addElement((ElementNode)specE, (XmlNameProvider)FeatureSpecXmlParser20.Element.PACKAGES));
        }
        return specE;
    }

    private void writeCaps(ElementNode parent, Set<CapabilitySpec> caps) {
        for (CapabilitySpec cap : caps) {
            ElementNode capE = FeatureSpecXmlWriter.addElement((ElementNode)parent, (XmlNameProvider)FeatureSpecXmlParser20.Element.CAPABILITY);
            FeatureSpecXmlWriter.addAttribute((ElementNode)capE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.NAME, (String)cap.toString());
            if (!cap.isOptional()) continue;
            FeatureSpecXmlWriter.addAttribute((ElementNode)capE, (XmlNameProvider)FeatureSpecXmlParser20.Attribute.OPTIONAL, (String)TRUE);
        }
    }
}

