/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlBaseParsers;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class PackageXmlParser30
implements PlugableXmlParser<PackageSpec.Builder> {
    public static final String NAMESPACE_3_0 = "urn:jboss:galleon:package:3.0";
    public static final QName ROOT_3_0 = new QName("urn:jboss:galleon:package:3.0", Element.PACKAGE_SPEC.getLocalName());

    public void plugin(XmlBaseParsers parsers) {
        parsers.plugin(ROOT_3_0, (XMLElementReader)this);
    }

    public QName getRoot() {
        return ROOT_3_0;
    }

    public void readElement(XMLExtendedStreamReader reader, PackageSpec.Builder pkgBuilder) throws XMLStreamException {
        this.parseAttributes(reader, pkgBuilder);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            PackageDepsSpecXmlParser.parsePackageDeps(Element.DEPENDENCIES, reader, pkgBuilder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseAttributes(XMLExtendedStreamReader reader, PackageSpec.Builder pkgBuilder) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String path = null;
        String stability = null;
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    path = reader.getAttributeValue(i);
                    continue block4;
                }
                case STABILITY_LEVEL: {
                    stability = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (path == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        pkgBuilder.setName(path);
        pkgBuilder.setStability(stability);
    }

    public static enum Element implements XmlNameProvider
    {
        DEPENDENCIES("dependencies"),
        PACKAGE_SPEC("package-spec"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:package:3.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(PackageXmlParser30.NAMESPACE_3_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return PackageXmlParser30.NAMESPACE_3_0;
        }

        static {
            elements = new HashMap<QName, Element>(3);
            elements.put(new QName(PackageXmlParser30.NAMESPACE_3_0, Element.DEPENDENCIES.name), DEPENDENCIES);
            elements.put(new QName(PackageXmlParser30.NAMESPACE_3_0, Element.PACKAGE_SPEC.name), PACKAGE_SPEC);
            elements.put(null, UNKNOWN);
        }
    }

    static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        STABILITY_LEVEL("stability-level"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(3);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.STABILITY_LEVEL.name), STABILITY_LEVEL);
            attributes.put(null, UNKNOWN);
        }
    }
}

