/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collection;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.PackageDepsSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class PackageXmlWriter
extends BaseXmlWriter<PackageSpec> {
    private static final String TRUE = "true";
    private static final PackageXmlWriter INSTANCE = new PackageXmlWriter();

    public static PackageXmlWriter getInstance() {
        return INSTANCE;
    }

    private PackageXmlWriter() {
    }

    protected ElementNode toElement(PackageSpec pkgSpec) {
        ElementNode pkg = PackageXmlWriter.addElement(null, (XmlNameProvider)PackageXmlParser30.Element.PACKAGE_SPEC);
        PackageXmlWriter.addAttribute((ElementNode)pkg, (XmlNameProvider)PackageXmlParser30.Attribute.NAME, (String)pkgSpec.getName());
        if (pkgSpec.getStability() != null) {
            PackageXmlWriter.addAttribute((ElementNode)pkg, (XmlNameProvider)PackageXmlParser30.Attribute.STABILITY_LEVEL, (String)pkgSpec.getStability().toString());
        }
        if (pkgSpec.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(pkgSpec, PackageXmlWriter.addElement((ElementNode)pkg, (String)PackageXmlParser30.Element.DEPENDENCIES.getLocalName(), (String)PackageXmlParser30.Element.DEPENDENCIES.getNamespace()));
        }
        return pkg;
    }

    static void writePackageDeps(PackageDepsSpec pkgDeps, ElementNode deps) {
        if (pkgDeps.hasLocalPackageDeps()) {
            for (PackageDependencySpec depSpec : pkgDeps.getLocalPackageDeps()) {
                PackageXmlWriter.writePackageDependency(deps, depSpec, deps.getNamespace());
            }
        }
        if (pkgDeps.hasExternalPackageDeps()) {
            for (String origin : pkgDeps.getPackageOrigins()) {
                PackageXmlWriter.writeOrigin(deps, origin, pkgDeps.getExternalPackageDeps(origin), deps.getNamespace());
            }
        }
    }

    private static void writeOrigin(ElementNode deps, String origin, Collection<PackageDependencySpec> depGroup, String ns) {
        ElementNode fpElement = PackageXmlWriter.addElement((ElementNode)deps, (String)"origin", (String)ns);
        PackageXmlWriter.addAttribute((ElementNode)fpElement, (XmlNameProvider)PackageXmlParser30.Attribute.NAME, (String)origin);
        for (PackageDependencySpec depSpec : depGroup) {
            PackageXmlWriter.writePackageDependency(fpElement, depSpec, ns);
        }
    }

    private static void writePackageDependency(ElementNode deps, PackageDependencySpec depSpec, String ns) {
        ElementNode depElement = PackageXmlWriter.addElement((ElementNode)deps, (String)"package", (String)ns);
        PackageXmlWriter.addAttribute((ElementNode)depElement, (XmlNameProvider)PackageXmlParser30.Attribute.NAME, (String)depSpec.getName());
        if (depSpec.isOptional()) {
            if (depSpec.isPassive()) {
                PackageXmlWriter.addAttribute((ElementNode)depElement, (XmlNameProvider)PackageDepsSpecXmlParser.Attribute.PASSIVE, (String)TRUE);
            } else {
                PackageXmlWriter.addAttribute((ElementNode)depElement, (XmlNameProvider)PackageDepsSpecXmlParser.Attribute.OPTIONAL, (String)TRUE);
            }
        }
    }
}

