/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.plugin.ProvisionedConfigHandler;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeature;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedConfigXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedConfigXmlWriter
extends BaseXmlWriter<ProvisionedConfig> {
    private static final ProvisionedConfigXmlWriter INSTANCE = new ProvisionedConfigXmlWriter();

    public static ProvisionedConfigXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedConfigXmlWriter() {
    }

    protected ElementNode toElement(ProvisionedConfig config) throws XMLStreamException {
        return this.toElement(config, "urn:jboss:galleon:provisioned-config:3.0");
    }

    protected ElementNode toElement(ProvisionedConfig config, String ns) throws XMLStreamException {
        ElementNode propE;
        ElementNode propsE;
        ElementNode configE = ProvisionedConfigXmlWriter.addElement(null, (String)ProvisionedConfigXmlParser30.Element.CONFIG.getLocalName(), (String)ns);
        if (config.getName() != null) {
            ProvisionedConfigXmlWriter.addAttribute((ElementNode)configE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.NAME, (String)config.getName());
        }
        if (config.getModel() != null) {
            ProvisionedConfigXmlWriter.addAttribute((ElementNode)configE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.MODEL, (String)config.getModel());
        }
        if (config.hasProperties()) {
            propsE = ProvisionedConfigXmlWriter.addElement((ElementNode)configE, (String)ProvisionedConfigXmlParser30.Element.PROPS.getLocalName(), (String)ns);
            for (Map.Entry entry : config.getProperties().entrySet()) {
                propE = ProvisionedConfigXmlWriter.addElement((ElementNode)propsE, (String)ProvisionedConfigXmlParser30.Element.PROP.getLocalName(), (String)ns);
                ProvisionedConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.NAME, (String)((String)entry.getKey()));
                ProvisionedConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.VALUE, (String)((String)entry.getValue()));
            }
        }
        if (config.hasLayers()) {
            propsE = ProvisionedConfigXmlWriter.addElement((ElementNode)configE, (String)ProvisionedConfigXmlParser30.Element.LAYERS.getLocalName(), (String)ns);
            for (ConfigId layerId : config.getLayers()) {
                propE = ProvisionedConfigXmlWriter.addElement((ElementNode)propsE, (String)ProvisionedConfigXmlParser30.Element.LAYER.getLocalName(), (String)ns);
                if (layerId.getModel() != null) {
                    ProvisionedConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.MODEL, (String)layerId.getModel());
                }
                ProvisionedConfigXmlWriter.addAttribute((ElementNode)propE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.NAME, (String)layerId.getName());
            }
        }
        if (config.hasFeatures()) {
            try {
                config.handle(new XmlConfigHandler(configE));
            }
            catch (ProvisioningException e) {
                throw new XMLStreamException("Failed to marshal ProvisionedConfig", e);
            }
        }
        return configE;
    }

    private static class XmlConfigHandler
    implements ProvisionedConfigHandler {
        private final ElementNode parent;
        private ElementNode fpElement;
        private ElementNode specElement;

        XmlConfigHandler(ElementNode parent) {
            this.parent = parent;
        }

        @Override
        public void nextFeaturePack(FeaturePackLocation.FPID fpid) {
            this.fpElement = BaseXmlWriter.addElement((ElementNode)this.parent, (String)ProvisionedConfigXmlParser30.Element.FEATURE_PACK.getLocalName(), (String)this.parent.getNamespace());
            BaseXmlWriter.addAttribute((ElementNode)this.fpElement, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.LOCATION, (String)fpid.toString());
        }

        @Override
        public void nextSpec(ResolvedFeatureSpec spec) {
            this.specElement = BaseXmlWriter.addElement((ElementNode)this.fpElement, (String)ProvisionedConfigXmlParser30.Element.SPEC.getLocalName(), (String)this.parent.getNamespace());
            BaseXmlWriter.addAttribute((ElementNode)this.specElement, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.NAME, (String)spec.getId().getName());
        }

        @Override
        public void nextFeature(ProvisionedFeature feature) throws ProvisioningException {
            ElementNode featureE = BaseXmlWriter.addElement((ElementNode)this.specElement, (String)ProvisionedConfigXmlParser30.Element.FEATURE.getLocalName(), (String)this.parent.getNamespace());
            if (feature.hasId()) {
                BaseXmlWriter.addAttribute((ElementNode)featureE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.ID, (String)feature.getId().toString());
            }
            if (feature.hasParams()) {
                for (String param : feature.getParamNames()) {
                    ElementNode paramE = BaseXmlWriter.addElement((ElementNode)featureE, (String)ProvisionedConfigXmlParser30.Element.PARAM.getLocalName(), (String)this.parent.getNamespace());
                    BaseXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.NAME, (String)param);
                    BaseXmlWriter.addAttribute((ElementNode)paramE, (XmlNameProvider)ProvisionedConfigXmlParser30.Attribute.VALUE, (String)feature.getConfigParam(param));
                }
            }
        }
    }
}

