/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.state.FeaturePack;
import org.jboss.galleon.state.FeaturePackPackage;
import org.jboss.galleon.state.FeaturePackSet;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ProvisionedConfigXmlWriter;
import org.jboss.galleon.xml.ProvisionedStateXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;

public class ProvisionedStateXmlWriter
extends BaseXmlWriter<FeaturePackSet<?>> {
    private static final ProvisionedStateXmlWriter INSTANCE = new ProvisionedStateXmlWriter();

    public static ProvisionedStateXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisionedStateXmlWriter() {
    }

    protected ElementNode toElement(FeaturePackSet<?> provisionedState) throws XMLStreamException {
        ElementNode pkg = ProvisionedStateXmlWriter.addElement(null, (XmlNameProvider)ProvisionedStateXmlParser30.Element.INSTALLATION);
        if (provisionedState.hasFeaturePacks()) {
            for (FeaturePack fp : provisionedState.getFeaturePacks()) {
                ElementNode fpElement = ProvisionedStateXmlWriter.addElement((ElementNode)pkg, (XmlNameProvider)ProvisionedStateXmlParser30.Element.FEATURE_PACK);
                this.writeFeaturePack(fpElement, fp);
            }
        }
        if (provisionedState.hasConfigs()) {
            for (ProvisionedConfig config : provisionedState.getConfigs()) {
                pkg.addChild(ProvisionedConfigXmlWriter.getInstance().toElement(config, ProvisionedStateXmlParser30.Element.CONFIG.getNamespace()));
            }
        }
        return pkg;
    }

    private void writeFeaturePack(ElementNode fp, FeaturePack<?> featurePack) {
        ProvisionedStateXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)ProvisionedStateXmlParser30.Attribute.LOCATION, (String)featurePack.getFPID().toString());
        if (featurePack.hasPackages()) {
            ElementNode packages = ProvisionedStateXmlWriter.addElement((ElementNode)fp, (XmlNameProvider)ProvisionedStateXmlParser30.Element.PACKAGES);
            for (FeaturePackPackage pkg : featurePack.getPackages()) {
                ElementNode pkgElement = ProvisionedStateXmlWriter.addElement((ElementNode)packages, (XmlNameProvider)ProvisionedStateXmlParser30.Element.PACKAGE);
                ProvisionedStateXmlWriter.addAttribute((ElementNode)pkgElement, (XmlNameProvider)ProvisionedStateXmlParser30.Attribute.NAME, (String)pkg.getName());
            }
        }
    }
}

