/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.xml.XmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisioningXmlParser
implements XmlParser<ProvisioningConfig> {
    private static final ProvisioningXmlParser INSTANCE = new ProvisioningXmlParser();

    public static ProvisioningXmlParser getInstance() {
        return INSTANCE;
    }

    public static ProvisioningConfig parse(Path path) throws ProvisioningException {
        ProvisioningConfig provisioningConfig;
        block9: {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                provisioningConfig = ProvisioningXmlParser.getInstance().parse(reader);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException e) {
                    throw new ProvisioningException(Errors.parseXml(path), (Throwable)e);
                }
            }
            reader.close();
        }
        return provisioningConfig;
    }

    private ProvisioningXmlParser() {
    }

    @Override
    public ProvisioningConfig parse(Reader input) throws XMLStreamException, ProvisioningDescriptionException {
        ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
        XmlParsers.parse(input, builder);
        return builder.build();
    }
}

