/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Arrays;
import java.util.Map;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.ConfigXmlWriter;
import org.jboss.galleon.xml.ProvisioningXmlParser30;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.TextNode;

public class ProvisioningXmlWriter
extends BaseXmlWriter<ProvisioningConfig> {
    private static final ProvisioningXmlWriter INSTANCE = new ProvisioningXmlWriter();
    private static final String FALSE = "false";

    public static ProvisioningXmlWriter getInstance() {
        return INSTANCE;
    }

    private ProvisioningXmlWriter() {
    }

    protected ElementNode toElement(ProvisioningConfig config) {
        ElementNode install = ProvisioningXmlWriter.addElement(null, (XmlNameProvider)ProvisioningXmlParser30.Element.INSTALLATION);
        ProvisioningXmlWriter.writeUniverseSpecs(config, install);
        if (config.hasTransitiveDeps()) {
            ElementNode transitives = ProvisioningXmlWriter.addElement((ElementNode)install, (XmlNameProvider)ProvisioningXmlParser30.Element.TRANSITIVE);
            for (FeaturePackConfig dep : config.getTransitiveDeps()) {
                ProvisioningXmlWriter.writeFeaturePackConfig(ProvisioningXmlWriter.addElement((ElementNode)transitives, (XmlNameProvider)ProvisioningXmlParser30.Element.FEATURE_PACK), config.getUserConfiguredLocation(dep.getLocation()), dep, config.originOf(dep.getLocation().getProducer()));
            }
        }
        if (config.hasFeaturePackDeps()) {
            for (FeaturePackConfig fp : config.getFeaturePackDeps()) {
                ElementNode fpElement = ProvisioningXmlWriter.addElement((ElementNode)install, (XmlNameProvider)ProvisioningXmlParser30.Element.FEATURE_PACK);
                ProvisioningXmlWriter.writeFeaturePackConfig(fpElement, config.getUserConfiguredLocation(fp.getLocation()), fp, config.originOf(fp.getLocation().getProducer()));
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(install, ProvisioningXmlParser30.Element.INSTALLATION.getNamespace(), config);
        if (config.hasOptions()) {
            Map<String, String> pluginOptions = config.getOptions();
            Object[] names = pluginOptions.keySet().toArray(new String[pluginOptions.size()]);
            Arrays.sort(names);
            ElementNode optionsE = ProvisioningXmlWriter.addElement((ElementNode)install, (XmlNameProvider)ProvisioningXmlParser30.Element.OPTIONS);
            for (Object name : names) {
                ElementNode optionE = ProvisioningXmlWriter.addElement((ElementNode)optionsE, (XmlNameProvider)ProvisioningXmlParser30.Element.OPTION);
                ProvisioningXmlWriter.addAttribute((ElementNode)optionE, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)name);
                String value = pluginOptions.get(name);
                if (value == null) continue;
                ProvisioningXmlWriter.addAttribute((ElementNode)optionE, (XmlNameProvider)ProvisioningXmlParser30.Attribute.VALUE, (String)value);
            }
        }
        return install;
    }

    static void writeUniverseSpecs(FeaturePackDepsConfig fpDeps, ElementNode parent) {
        ElementNode universesEl = null;
        UniverseSpec universeSpec = fpDeps.getDefaultUniverse();
        if (universeSpec != null) {
            universesEl = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.UNIVERSES.getLocalName(), (String)parent.getNamespace());
            ProvisioningXmlWriter.writeUniverseConfig(universesEl, null, universeSpec.getFactory(), universeSpec.getLocation());
        }
        if (fpDeps.hasUniverseNamedSpecs()) {
            if (universesEl == null) {
                universesEl = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.UNIVERSES.getLocalName(), (String)parent.getNamespace());
            }
            for (Map.Entry<String, UniverseSpec> universe : fpDeps.getUniverseNamedSpecs().entrySet()) {
                ProvisioningXmlWriter.writeUniverseConfig(universesEl, universe.getKey(), universe.getValue().getFactory(), universe.getValue().getLocation());
            }
        }
    }

    private static void writeUniverseConfig(ElementNode universesEl, String name, String factory, String location) {
        ElementNode universeEl = ProvisioningXmlWriter.addElement((ElementNode)universesEl, (String)ProvisioningXmlParser30.Element.UNIVERSE.getLocalName(), (String)universesEl.getNamespace());
        if (name != null) {
            ProvisioningXmlWriter.addAttribute((ElementNode)universeEl, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)name);
        }
        ProvisioningXmlWriter.addAttribute((ElementNode)universeEl, (XmlNameProvider)ProvisioningXmlParser30.Attribute.FACTORY, (String)factory);
        if (location != null) {
            ProvisioningXmlWriter.addAttribute((ElementNode)universeEl, (XmlNameProvider)ProvisioningXmlParser30.Attribute.LOCATION, (String)location);
        }
    }

    static void writeFeaturePackConfig(ElementNode fp, FeaturePackLocation location, FeaturePackConfig featurePack, String origin) {
        String ns = fp.getNamespace();
        ProvisioningXmlWriter.addAttribute((ElementNode)fp, (XmlNameProvider)ProvisioningXmlParser30.Attribute.LOCATION, (String)location.toString());
        if (origin != null) {
            ProvisioningXmlWriter.addElement((ElementNode)fp, (String)ProvisioningXmlParser30.Element.ORIGIN.getLocalName(), (String)ns).addChild(new TextNode(origin));
        }
        if (featurePack.hasPatches()) {
            ElementNode patches = ProvisioningXmlWriter.addElement((ElementNode)fp, (String)ProvisioningXmlParser30.Element.PATCHES.getLocalName(), (String)ns);
            for (FeaturePackLocation.FPID patchId : featurePack.getPatches()) {
                ElementNode patch = ProvisioningXmlWriter.addElement((ElementNode)patches, (String)ProvisioningXmlParser30.Element.PATCH.getLocalName(), (String)ns);
                ProvisioningXmlWriter.addAttribute((ElementNode)patch, (XmlNameProvider)ProvisioningXmlParser30.Attribute.ID, (String)patchId.toString());
            }
        }
        ProvisioningXmlWriter.writeConfigCustomizations(fp, ns, featurePack);
        ElementNode packages = null;
        Boolean inheritPackages = featurePack.getInheritPackages();
        if (inheritPackages != null) {
            packages = ProvisioningXmlWriter.addElement((ElementNode)fp, (String)ProvisioningXmlParser30.Element.PACKAGES.getLocalName(), (String)ns);
            ProvisioningXmlWriter.addAttribute((ElementNode)packages, (XmlNameProvider)ProvisioningXmlParser30.Attribute.INHERIT, (String)String.valueOf(inheritPackages));
        }
        if (featurePack.hasExcludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement((ElementNode)fp, (String)ProvisioningXmlParser30.Element.PACKAGES.getLocalName(), (String)ns);
            }
            for (String excluded : featurePack.getExcludedPackages()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement((ElementNode)packages, (String)ProvisioningXmlParser30.Element.EXCLUDE.getLocalName(), (String)ns);
                ProvisioningXmlWriter.addAttribute((ElementNode)exclude, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)excluded);
            }
        }
        if (featurePack.hasIncludedPackages()) {
            if (packages == null) {
                packages = ProvisioningXmlWriter.addElement((ElementNode)fp, (String)ProvisioningXmlParser30.Element.PACKAGES.getLocalName(), (String)ns);
            }
            for (String included : featurePack.getIncludedPackages()) {
                ElementNode include = ProvisioningXmlWriter.addElement((ElementNode)packages, (String)ProvisioningXmlParser30.Element.INCLUDE.getLocalName(), (String)ns);
                ProvisioningXmlWriter.addAttribute((ElementNode)include, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)included);
            }
        }
    }

    static void writeConfigCustomizations(ElementNode parent, String ns, ConfigCustomizations configCustoms) {
        ElementNode defConfigsE = null;
        Boolean inheritConfigs = configCustoms.getInheritConfigs();
        if (inheritConfigs != null) {
            defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            ProvisioningXmlWriter.addAttribute((ElementNode)defConfigsE, (XmlNameProvider)ProvisioningXmlParser30.Attribute.INHERIT, (String)inheritConfigs.toString());
        }
        if (!configCustoms.isInheritModelOnlyConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            }
            ProvisioningXmlWriter.addAttribute((ElementNode)defConfigsE, (XmlNameProvider)ProvisioningXmlParser30.Attribute.INHERIT_UNNAMED_MODELS, (String)FALSE);
        }
        if (configCustoms.hasFullModelsExcluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            }
            for (Map.Entry<String, Boolean> entry : configCustoms.getFullModelsExcluded().entrySet()) {
                ElementNode exclude = ProvisioningXmlWriter.addElement((ElementNode)defConfigsE, (String)ProvisioningXmlParser30.Element.EXCLUDE.getLocalName(), (String)ns);
                ProvisioningXmlWriter.addAttribute((ElementNode)exclude, (XmlNameProvider)ProvisioningXmlParser30.Attribute.MODEL, (String)entry.getKey());
                if (entry.getValue().booleanValue()) continue;
                ProvisioningXmlWriter.addAttribute((ElementNode)exclude, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAMED_MODELS_ONLY, (String)FALSE);
            }
        }
        if (configCustoms.hasFullModelsIncluded()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            }
            Object[] array = configCustoms.getFullModelsIncluded().toArray(new String[configCustoms.getFullModelsIncluded().size()]);
            Arrays.sort(array);
            for (Object modelName : array) {
                ElementNode included = ProvisioningXmlWriter.addElement((ElementNode)defConfigsE, (String)ProvisioningXmlParser30.Element.INCLUDE.getLocalName(), (String)ns);
                ProvisioningXmlWriter.addAttribute((ElementNode)included, (XmlNameProvider)ProvisioningXmlParser30.Attribute.MODEL, (String)modelName);
            }
        }
        if (configCustoms.hasExcludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            }
            for (ConfigId configId : configCustoms.getExcludedConfigs()) {
                ElementNode excluded = ProvisioningXmlWriter.addElement((ElementNode)defConfigsE, (String)ProvisioningXmlParser30.Element.EXCLUDE.getLocalName(), (String)ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute((ElementNode)excluded, (XmlNameProvider)ProvisioningXmlParser30.Attribute.MODEL, (String)configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute((ElementNode)excluded, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)configId.getName());
            }
        }
        if (configCustoms.hasIncludedConfigs()) {
            if (defConfigsE == null) {
                defConfigsE = ProvisioningXmlWriter.addElement((ElementNode)parent, (String)ProvisioningXmlParser30.Element.DEFAULT_CONFIGS.getLocalName(), (String)ns);
            }
            for (ConfigId configId : configCustoms.getIncludedConfigs()) {
                ElementNode includeElement = ProvisioningXmlWriter.addElement((ElementNode)defConfigsE, (String)ProvisioningXmlParser30.Element.INCLUDE.getLocalName(), (String)ns);
                if (configId.getModel() != null) {
                    ProvisioningXmlWriter.addAttribute((ElementNode)includeElement, (XmlNameProvider)ProvisioningXmlParser30.Attribute.MODEL, (String)configId.getModel());
                }
                if (configId.getName() == null) continue;
                ProvisioningXmlWriter.addAttribute((ElementNode)includeElement, (XmlNameProvider)ProvisioningXmlParser30.Attribute.NAME, (String)configId.getName());
            }
        }
        if (configCustoms.hasDefinedConfigs()) {
            for (ConfigModel configModel : configCustoms.getDefinedConfigs()) {
                parent.addChild(ConfigXmlWriter.getInstance().toElement(configModel, ns));
            }
        }
    }
}

