/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.BufferedReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.xml.ConfigLayerXmlParser10;
import org.jboss.galleon.xml.ConfigLayerXmlParser20;
import org.jboss.galleon.xml.ConfigXmlParser10;
import org.jboss.galleon.xml.FeatureConfigXmlParser10;
import org.jboss.galleon.xml.FeatureGroupXmlParser10;
import org.jboss.galleon.xml.FeaturePackXmlParser20;
import org.jboss.galleon.xml.FeaturePackXmlParser30;
import org.jboss.galleon.xml.FeatureSpecXmlParser10;
import org.jboss.galleon.xml.FeatureSpecXmlParser20;
import org.jboss.galleon.xml.PackageXmlParser10;
import org.jboss.galleon.xml.PackageXmlParser20;
import org.jboss.galleon.xml.PackageXmlParser30;
import org.jboss.galleon.xml.ProvisionedConfigXmlParser30;
import org.jboss.galleon.xml.ProvisionedStateXmlParser30;
import org.jboss.galleon.xml.ProvisioningXmlParser30;
import org.jboss.galleon.xml.XmlBaseParsers;

public class XmlParsers
extends XmlBaseParsers {
    private static final XmlParsers INSTANCE = new XmlParsers();

    public static XmlParsers getInstance() {
        return INSTANCE;
    }

    public static void parse(Reader reader, Object builder) throws XMLStreamException {
        INSTANCE.doParse(reader, builder);
    }

    public static ConfigLayerSpec parseConfigLayerSpec(Path p, String model) throws ProvisioningException {
        ConfigLayerSpec configLayerSpec;
        block8: {
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                configLayerSpec = XmlParsers.parseConfigLayerSpec(reader, model);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningException(Errors.parseXml(p), (Throwable)e);
                }
            }
            reader.close();
        }
        return configLayerSpec;
    }

    public static ConfigLayerSpec parseConfigLayerSpec(Reader reader, String model) throws ProvisioningException {
        ConfigLayerSpec.Builder builder = ConfigLayerSpec.builder();
        builder.setModel(model);
        try {
            XmlParsers.parse(reader, builder);
        }
        catch (XMLStreamException e) {
            throw new ProvisioningException("Failed to parse config layer spec", (Throwable)e);
        }
        return builder.build();
    }

    private XmlParsers() {
        new ConfigLayerXmlParser10().plugin(this);
        new ConfigLayerXmlParser20().plugin(this);
        new ConfigXmlParser10().plugin(this);
        new FeatureConfigXmlParser10().plugin(this);
        new FeatureGroupXmlParser10().plugin(this);
        new FeaturePackXmlParser20().plugin(this);
        new FeaturePackXmlParser30().plugin(this);
        new FeatureSpecXmlParser10().plugin(this);
        new FeatureSpecXmlParser20().plugin(this);
        new PackageXmlParser10().plugin(this);
        new PackageXmlParser20().plugin(this);
        new PackageXmlParser30().plugin(this);
        new ProvisionedStateXmlParser30().plugin(this);
        new ProvisionedConfigXmlParser30().plugin(this);
        new ProvisioningXmlParser30().plugin(this);
    }
}

