/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFactory;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenUniverse;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.MvnNoLocUniverse;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.universe.maven.repo.SimplisticMavenRepoManager;

public class MavenUniverseFactory
implements UniverseFactory {
    public static final String DEFAULT_REPO_ID = "repository.maven";
    public static final String ID = "maven";

    public String getFactoryId() {
        return ID;
    }

    public String getRepositoryId() {
        return DEFAULT_REPO_ID;
    }

    public Universe<?> getUniverse(RepositoryArtifactResolver artifactResolver, String location, boolean absoluteLatest) throws ProvisioningException {
        MavenRepoManager repo;
        if (artifactResolver != null) {
            if (!(artifactResolver instanceof MavenRepoManager)) {
                throw new MavenUniverseException(artifactResolver.getClass().getName() + " is not an instance of " + MavenRepoManager.class.getName());
            }
            repo = (MavenRepoManager)artifactResolver;
        } else {
            repo = SimplisticMavenRepoManager.getInstance();
        }
        if (location == null) {
            return new MvnNoLocUniverse(repo);
        }
        try {
            return new MavenUniverse(repo, MavenArtifact.fromString(location), absoluteLatest);
        }
        catch (MavenUniverseException e) {
            throw new MavenUniverseException(MavenErrors.msgUniverseNotFound(location), (Throwable)((Object)e));
        }
    }
}

