/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven.repo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenErrors;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.LocalArtifactVersionRangeResolver;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;

public class SimplisticMavenRepoManager
extends LocalArtifactVersionRangeResolver
implements MavenRepoManager {
    public static final String REPOSITORY_ID = "repository.maven";
    public static final String SIMPLISTIC_MAVEN_REPO_HOME = "simplistic.maven.repo.home";
    private final MavenRepoManager fallback;
    private boolean locallyAvailableVersionRangesPreferred = true;

    public static SimplisticMavenRepoManager getInstance() {
        String prop = System.getProperty(SIMPLISTIC_MAVEN_REPO_HOME);
        return SimplisticMavenRepoManager.getInstance(prop == null ? Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2") : Paths.get(prop, new String[0]));
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome) {
        return new SimplisticMavenRepoManager(repoHome, null);
    }

    public static SimplisticMavenRepoManager getInstance(Path repoHome, MavenRepoManager fallback) {
        return new SimplisticMavenRepoManager(repoHome, fallback);
    }

    private SimplisticMavenRepoManager(Path repoHome, MavenRepoManager fallback) {
        super(repoHome);
        this.fallback = fallback;
    }

    public boolean isLocallyAvailableVersionRangesPreferred() {
        return this.locallyAvailableVersionRangesPreferred;
    }

    public void setLocallyAvailableVersionRangesPreferred(boolean locallyAvailableVersionRangesPreferred) {
        this.locallyAvailableVersionRangesPreferred = locallyAvailableVersionRangesPreferred;
    }

    @Override
    public String getRepositoryId() {
        return REPOSITORY_ID;
    }

    @Override
    public Path resolve(String location) throws ProvisioningException {
        return MavenRepoManager.super.resolve(location);
    }

    @Override
    public void resolve(MavenArtifact artifact) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already resolved");
        }
        Path path = null;
        try {
            path = this.getArtifactPath(artifact);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path));
            }
            artifact.setPath(path);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            try {
                this.fallback.resolve(artifact);
            }
            catch (MavenUniverseException e2) {
                throw new MavenUniverseException(this.pathDoesNotExist(artifact, path), (Throwable)((Object)e2));
            }
            return;
        }
    }

    @Override
    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier, boolean locally) throws MavenUniverseException {
        if (this.locallyAvailableVersionRangesPreferred) {
            try {
                super.resolveLatestVersion(artifact, lowestQualifier);
                return;
            }
            catch (MavenUniverseException e) {
                if (this.fallback == null) {
                    throw e;
                }
                this.fallback.resolveLatestVersion(artifact, lowestQualifier, locally);
                return;
            }
        }
        if (locally) {
            super.resolveLatestVersion(artifact, lowestQualifier);
            return;
        }
        if (this.fallback == null) {
            throw new MavenUniverseException(MavenErrors.failedToResolveLatestVersion(artifact.getCoordsAsString()));
        }
        this.fallback.resolveLatestVersion(artifact, lowestQualifier);
    }

    @Override
    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        this.resolveLatestVersion(artifact, lowestQualifier, null, null);
    }

    @Override
    public void resolveLatestVersion(MavenArtifact artifact, String lowestQualifier, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        try {
            super.resolveLatestVersion(artifact, lowestQualifier, includeVersion, excludeVersion);
            return;
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            this.fallback.resolveLatestVersion(artifact, lowestQualifier, includeVersion, excludeVersion);
            return;
        }
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        try {
            return super.getLatestVersion(artifact, lowestQualifier);
        }
        catch (MavenUniverseException e) {
            if (this.fallback == null) {
                throw e;
            }
            return this.fallback.getLatestVersion(artifact, lowestQualifier);
        }
    }

    @Override
    public void install(MavenArtifact artifact, Path path) throws MavenUniverseException {
        if (artifact.isResolved()) {
            throw new MavenUniverseException("Artifact is already associated with a path " + path);
        }
        Path targetPath = this.getArtifactPath(artifact);
        try {
            IoUtils.copy((Path)path, (Path)targetPath);
        }
        catch (IOException e) {
            throw new MavenUniverseException("Failed to install " + artifact.getCoordsAsString(), e);
        }
        artifact.setPath(targetPath);
    }

    private Path getArtifactPath(MavenArtifact artifact) throws MavenUniverseException {
        String[] groupParts;
        if (artifact.getGroupId() == null) {
            MavenErrors.missingGroupId();
        }
        Path p = this.repoHome;
        for (String part : groupParts = artifact.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        String artifactFileName = artifact.getArtifactFileName();
        return p.resolve(artifact.getArtifactId()).resolve(artifact.getVersion()).resolve(artifactFileName);
    }

    @Override
    public boolean isResolved(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isLatestVersionResolved(MavenArtifact artifact, String lowestQualifier) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getLatestVersion(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> getAllVersions(MavenArtifact artifact) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<String> getAllVersions(MavenArtifact artifact, Pattern includeVersion, Pattern excludeVersion) throws MavenUniverseException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

