/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds;

import java.util.HashMap;
import java.util.Map;

public enum TransactionIsolation {
    TRANSACTION_READ_UNCOMMITTED("TRANSACTION_READ_UNCOMMITTED", 1),
    TRANSACTION_READ_COMMITTED("TRANSACTION_READ_COMMITTED", 2),
    TRANSACTION_REPEATABLE_READ("TRANSACTION_REPEATABLE_READ", 4),
    TRANSACTION_SERIALIZABLE("TRANSACTION_SERIALIZABLE", 8),
    TRANSACTION_NONE("TRANSACTION_NONE", 0);

    private static final Map<String, TransactionIsolation> MAP;
    private String name;
    private int constant;

    private TransactionIsolation(String n2, int c) {
        this.name = n2;
        this.constant = c;
    }

    int getConstant() {
        return this.constant;
    }

    public static TransactionIsolation forName(String v) {
        return MAP.get(v);
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, TransactionIsolation> map = new HashMap<String, TransactionIsolation>();
        for (TransactionIsolation v : TransactionIsolation.values()) {
            String name = v.name();
            if (name == null) continue;
            map.put(name, v);
            map.put(Integer.toString(v.getConstant()), v);
        }
        MAP = map;
    }
}

