/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ra;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.ra.IdDecoratedMetadata;
import org.jboss.jca.common.api.metadata.ra.LocalizedMetadata;
import org.jboss.jca.common.api.metadata.ra.Path;

public class Icon
implements IdDecoratedMetadata,
LocalizedMetadata,
CopyableMetaData {
    private static final long serialVersionUID = 7809751095477978996L;
    private final Path smallIcon;
    private final Path largeIcon;
    private final String lang;
    private final String id;

    public Icon(Path smallIcon, Path largeIcon, String lang, String id) {
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
        this.lang = lang;
        this.id = id;
    }

    public Icon(Path smallIcon, Path largeIcon, String id) {
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
        this.lang = "en";
        this.id = id;
    }

    public Path getSmallIcon() {
        return this.smallIcon;
    }

    public Path getLargeIcon() {
        return this.largeIcon;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.largeIcon == null ? 0 : this.largeIcon.hashCode());
        result = 31 * result + (this.smallIcon == null ? 0 : this.smallIcon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Icon)) {
            return false;
        }
        Icon other = (Icon)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
            return false;
        }
        if (this.largeIcon == null ? other.largeIcon != null : !this.largeIcon.equals(other.largeIcon)) {
            return false;
        }
        return !(this.smallIcon == null ? other.smallIcon != null : !this.smallIcon.equals(other.smallIcon));
    }

    public String toString() {
        return "Icon [smallIcon=" + this.smallIcon + ", largeIcon=" + this.largeIcon + ", lang=" + this.lang + ", id=" + this.id + "]";
    }

    @Override
    public CopyableMetaData copy() {
        return new Icon(CopyUtil.clone(this.smallIcon), CopyUtil.clone(this.largeIcon), CopyUtil.cloneString(this.id));
    }

    public static enum Attribute {
        UNKNOWN(null),
        ID("id"),
        LANG("lang");

        private String name;
        private static final Map<String, Attribute> MAP;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Attribute value(String v) {
            this.name = v;
            return this;
        }

        public static Attribute forName(String localName) {
            Attribute element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Attribute> map = new HashMap<String, Attribute>();
            for (Attribute element : Attribute.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        SMALL_ICON("small-icon"),
        LARGE_ICON("large-icon");

        private String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        Tag value(String v) {
            this.name = v;
            return this;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN.value(localName) : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

