/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.spi.workmanager;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Address
implements Comparable<Address>,
Serializable {
    private static final long serialVersionUID = 2L;
    private String workManagerId;
    private String workManagerName;
    private String transportId;
    private static final String ID = "ID";
    private static final String NAME = "NAME";
    private static final String TRANSPORT_ID = "TRANSPORT_ID";

    public static Address fromMap(Map<String, String> map) {
        return new Address(map.get(ID), map.get(NAME), map.get(TRANSPORT_ID));
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>(3);
        returnMap.put(ID, this.getWorkManagerId());
        returnMap.put(NAME, this.getWorkManagerName());
        returnMap.put(TRANSPORT_ID, this.getTransportId());
        return returnMap;
    }

    public Address(String workManagerId, String workManagerName, String transportId) {
        if (workManagerId == null || workManagerId.trim().equals("")) {
            throw new IllegalArgumentException("WorkManagerId is undefined");
        }
        if (workManagerName == null || workManagerName.trim().equals("")) {
            throw new IllegalArgumentException("WorkManagerName is undefined");
        }
        this.workManagerId = workManagerId;
        this.workManagerName = workManagerName;
        this.transportId = transportId;
    }

    public String getWorkManagerId() {
        return this.workManagerId;
    }

    public String getWorkManagerName() {
        return this.workManagerName;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public int hashCode() {
        int result = 37;
        result += 7 * this.workManagerId.hashCode();
        result += 7 * this.workManagerName.hashCode();
        return result += this.transportId != null ? 7 * this.transportId.hashCode() : 7;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Address)) {
            return false;
        }
        Address a = (Address)o;
        if (!this.workManagerId.equals(a.workManagerId)) {
            return false;
        }
        if (!this.workManagerName.equals(a.workManagerName)) {
            return false;
        }
        return !(this.transportId != null ? !this.transportId.equals(a.transportId) : a.transportId != null);
    }

    @Override
    public int compareTo(Address a) {
        int compare = this.workManagerId.compareTo(a.getWorkManagerId());
        if (compare != 0) {
            return compare;
        }
        compare = this.workManagerName.compareTo(a.getWorkManagerName());
        if (compare != 0) {
            return compare;
        }
        if (this.transportId != null) {
            if (a.getTransportId() != null) {
                return this.transportId.compareTo(a.getTransportId());
            }
            return 1;
        }
        if (a.getTransportId() != null) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Address@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[workManagerId=").append(this.workManagerId);
        sb.append(" workManagerName=").append(this.workManagerName);
        sb.append(" transportId=").append(this.transportId);
        sb.append("]");
        return sb.toString();
    }
}

