/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.spi.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class TxUtils {
    private static final String[] TX_STATUS_STRINGS = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};

    private TxUtils() {
    }

    public static boolean isActive(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0;
        }
        catch (SystemException error) {
            throw new RuntimeException("Error during isActive()", error);
        }
    }

    public static boolean isUncommitted(Transaction tx) {
        if (tx == null) {
            return false;
        }
        try {
            int status = tx.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException error) {
            throw new RuntimeException("Error during isUncommitted()", error);
        }
    }

    public static boolean isCompleted(Transaction tx) {
        if (tx == null) {
            return true;
        }
        try {
            int status = tx.getStatus();
            return status == 3 || status == 4 || status == 6;
        }
        catch (SystemException error) {
            throw new RuntimeException("Error during isCompleted()", error);
        }
    }

    public static String getStatusAsString(int status) {
        if (status >= 0 && status <= 9) {
            return TX_STATUS_STRINGS[status];
        }
        return "STATUS_INVALID(" + status + ")";
    }
}

