/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableUnavailableException;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.connectionmanager.pool.idle.IdleRemover;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolUtility;
import org.jboss.jca.core.connectionmanager.pool.mcp.PoolFiller;
import org.jboss.jca.core.connectionmanager.pool.mcp.Semaphore;
import org.jboss.jca.core.connectionmanager.pool.validator.ConnectionValidator;
import org.jboss.logging.Messages;

public class SemaphoreArrayListManagedConnectionPool
implements ManagedConnectionPool {
    private CoreLogger log;
    private boolean debug;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private Subject defaultSubject;
    private ConnectionRequestInfo defaultCri;
    private PoolConfiguration poolConfiguration;
    private Pool pool;
    private int maxSize;
    private ArrayList<ConnectionListener> cls;
    private Semaphore permits;
    private final ConcurrentMap<ConnectionListener, ConnectionListener> clPermits = new ConcurrentHashMap<ConnectionListener, ConnectionListener>();
    private final ArrayList<ConnectionListener> checkedOut = new ArrayList();
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private ManagedConnectionPoolStatisticsImpl statistics;

    @Override
    public void initialize(ManagedConnectionFactory mcf, ConnectionListenerFactory clf, Subject subject, ConnectionRequestInfo cri, PoolConfiguration pc, Pool p) {
        if (mcf == null) {
            throw new IllegalArgumentException("ManagedConnectionFactory is null");
        }
        if (clf == null) {
            throw new IllegalArgumentException("ConnectionListenerFactory is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        if (p == null) {
            throw new IllegalArgumentException("Pool is null");
        }
        this.mcf = mcf;
        this.clf = clf;
        this.defaultSubject = subject;
        this.defaultCri = cri;
        this.poolConfiguration = pc;
        this.maxSize = pc.getMaxSize();
        this.pool = p;
        this.log = this.pool.getLogger();
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.cls = new ArrayList(this.maxSize);
        this.statistics = new ManagedConnectionPoolStatisticsImpl(this.maxSize);
        this.permits = new Semaphore(this.maxSize, true, this.statistics);
        if ((pc.isPrefill() || pc.isStrictMin()) && p instanceof PrefillPool && pc.getMinSize() > 0) {
            PoolFiller.fillPool(this);
        }
        this.reenable();
    }

    @Override
    public boolean isRunning() {
        return !this.shutdown.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() == 0 && this.checkedOut.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSize(int size) {
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            return this.cls.size() + this.checkedOut.size() >= size;
        }
    }

    @Override
    public void reenable() {
        if (this.poolConfiguration.getIdleTimeoutMinutes() > 0) {
            IdleRemover.getInstance().registerPool(this, (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L);
        }
        if (this.poolConfiguration.isBackgroundValidation() && this.poolConfiguration.getBackgroundValidationMillis() > 0L) {
            if (this.debug) {
                this.log.debug("Registering for background validation at interval " + this.poolConfiguration.getBackgroundValidationMillis());
            }
            ConnectionValidator.getInstance().registerPool(this, this.poolConfiguration.getBackgroundValidationMillis());
        }
        this.shutdown.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionListener getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (this.trace) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                String method = "getConnection(" + subject + ", " + cri + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "getConnection(" + subject + ", " + cri + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        subject = subject == null ? this.defaultSubject : subject;
        cri = cri == null ? this.defaultCri : cri;
        long startWait = System.currentTimeMillis();
        try {
            if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) {
                ArrayList<ConnectionListener> arrayList;
                this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                ConnectionListener cl = null;
                do {
                    ArrayList<ConnectionListener> arrayList2 = this.cls;
                    synchronized (arrayList2) {
                        if (this.shutdown.get()) {
                            this.permits.release();
                            throw new RetryableUnavailableException(bundle.thePoolHasBeenShutdown(this.pool.getName(), Integer.toHexString(System.identityHashCode(this))));
                        }
                        if (this.cls.size() > 0) {
                            cl = this.cls.remove(0);
                            this.checkedOut.add(cl);
                            this.statistics.setInUsedCount(this.checkedOut.size());
                        }
                    }
                    if (cl == null) continue;
                    try {
                        ManagedConnection matchedMC = this.mcf.matchManagedConnections(Collections.singleton(cl.getManagedConnection()), subject, cri);
                        if (matchedMC != null) {
                            if (this.trace) {
                                this.log.trace("supplying ManagedConnection from pool: " + cl);
                            }
                            this.clPermits.put(cl, cl);
                            return cl;
                        }
                        this.log.destroyingConnectionNotSuccessfullyMatched(cl);
                        arrayList = this.cls;
                        synchronized (arrayList) {
                            this.checkedOut.remove(cl);
                            this.statistics.setInUsedCount(this.checkedOut.size());
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    catch (Throwable t) {
                        this.log.throwableWhileTryingMatchManagedConnectionThenDestroyingConnection(cl, t);
                        arrayList = this.cls;
                        synchronized (arrayList) {
                            this.checkedOut.remove(cl);
                            this.statistics.setInUsedCount(this.checkedOut.size());
                        }
                        this.doDestroy(cl);
                        cl = null;
                    }
                    if (!this.poolConfiguration.isUseFastFail()) continue;
                    if (!this.trace) break;
                    this.log.trace("Fast failing for connection attempt. No more attempts will be made to acquire connection from pool and a new connection will be created immeadiately");
                    break;
                } while (this.cls.size() > 0);
                try {
                    cl = this.createConnectionEventListener(subject, cri);
                    if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool && this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    }
                    ArrayList<ConnectionListener> t = this.cls;
                    synchronized (t) {
                        this.checkedOut.add(cl);
                        this.statistics.setInUsedCount(this.checkedOut.size());
                    }
                    if (this.trace) {
                        this.log.trace("supplying new ManagedConnection: " + cl);
                    }
                    this.clPermits.put(cl, cl);
                    return cl;
                }
                catch (Throwable t) {
                    this.log.throwableWhileAttemptingGetNewGonnection(cl, t);
                    arrayList = this.cls;
                    synchronized (arrayList) {
                        this.checkedOut.remove(cl);
                        this.statistics.setInUsedCount(this.checkedOut.size());
                    }
                    this.permits.release();
                    throw new ResourceException(bundle.unexpectedThrowableWhileTryingCreateConnection(cl), t);
                }
            }
            throw new ResourceException(bundle.noMManagedConnectionsAvailableWithinConfiguredBlockingTimeout(this.poolConfiguration.getBlockingTimeout()));
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            long end = System.currentTimeMillis() - startWait;
            this.statistics.deltaTotalBlockingTime(end);
            throw new ResourceException(bundle.interruptedWhileRequestingPermit(end));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) {
        ArrayList<ConnectionListener> arrayList;
        if (this.trace) {
            arrayList = this.cls;
            synchronized (arrayList) {
                String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
                this.log.trace(ManagedConnectionPoolUtility.fullDetails(System.identityHashCode(this), method, this.mcf, this.clf, this.pool, this.poolConfiguration, this.cls, this.checkedOut, this.statistics));
            }
        } else if (this.debug) {
            String method = "returnConnection(" + Integer.toHexString(System.identityHashCode(cl)) + ", " + kill + ")";
            this.log.debug(ManagedConnectionPoolUtility.details(method, this.pool.getName(), this.statistics.getInUseCount(), this.maxSize));
        }
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace("ManagedConnection is being returned after it was destroyed: " + cl);
            }
            if (this.clPermits.containsKey(cl)) {
                this.clPermits.remove(cl);
                this.permits.release();
            }
            return;
        }
        try {
            cl.getManagedConnection().cleanup();
        }
        catch (ResourceException re) {
            this.log.resourceExceptionCleaningUpManagedConnection(cl, re);
            kill = true;
        }
        arrayList = this.cls;
        synchronized (arrayList) {
            if (cl.getState() == ConnectionState.DESTROY || cl.getState() == ConnectionState.DESTROYED) {
                kill = true;
            }
            this.checkedOut.remove(cl);
            this.statistics.setInUsedCount(this.checkedOut.size());
            if (!kill && this.isSize(this.poolConfiguration.getMaxSize() + 1)) {
                this.log.destroyingReturnedConnectionMaximumPoolSizeExceeded(cl);
                kill = true;
            }
            if (kill) {
                this.cls.remove(cl);
            } else {
                cl.used();
                if (!this.cls.contains(cl)) {
                    this.cls.add(cl);
                } else {
                    this.log.attemptReturnConnectionTwice(cl, new Throwable("STACKTRACE"));
                }
            }
            if (this.clPermits.containsKey(cl)) {
                this.clPermits.remove(cl);
                this.permits.release();
            }
        }
        if (kill) {
            if (this.trace) {
                this.log.trace("Destroying returned connection " + cl);
            }
            this.doDestroy(cl);
            cl = null;
        }
    }

    @Override
    public void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(boolean kill) {
        ArrayList<ConnectionListener> destroy = null;
        ArrayList<ConnectionListener> arrayList = this.cls;
        synchronized (arrayList) {
            ConnectionListener cl;
            if (kill) {
                if (this.trace) {
                    this.log.trace("Flushing pool checkedOut=" + this.checkedOut + " inPool=" + this.cls);
                }
                while (this.checkedOut.size() > 0) {
                    cl = this.checkedOut.remove(0);
                    if (this.trace) {
                        this.log.trace("Flush marking checked out connection for destruction " + cl);
                    }
                    cl.setState(ConnectionState.DESTROY);
                    if (destroy == null) {
                        destroy = new ArrayList(1);
                    }
                    destroy.add(cl);
                    if (!this.clPermits.containsKey(cl)) continue;
                    this.clPermits.remove(cl);
                    this.permits.release();
                }
                this.statistics.setInUsedCount(this.checkedOut.size());
            }
            while (this.cls.size() > 0) {
                cl = this.cls.remove(0);
                if (destroy == null) {
                    destroy = new ArrayList<ConnectionListener>(1);
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (ConnectionListener cl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying flushed connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
        }
        if (!this.shutdown.get() && this.poolConfiguration.getMinSize() > 0 && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
            PoolFiller.fillPool(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleConnections() {
        ArrayList<ConnectionListener> destroy = null;
        long timeout = System.currentTimeMillis() - (long)this.poolConfiguration.getIdleTimeoutMinutes() * 1000L * 60L;
        while (true) {
            ArrayList<ConnectionListener> arrayList = this.cls;
            synchronized (arrayList) {
                if (this.cls.size() == 0) {
                    break;
                }
                ConnectionListener cl = this.cls.get(0);
                if (cl.isTimedOut(timeout) && this.shouldRemove()) {
                    this.statistics.deltaTimedOut();
                    this.cls.remove(0);
                    if (destroy == null) {
                        destroy = new ArrayList<ConnectionListener>(1);
                    }
                } else {
                    break;
                }
                destroy.add(cl);
            }
        }
        if (destroy != null) {
            for (ConnectionListener cl : destroy) {
                if (this.trace) {
                    this.log.trace("Destroying timedout connection " + cl);
                }
                this.doDestroy(cl);
                cl = null;
            }
            if (!this.shutdown.get()) {
                boolean emptyManagedConnectionPool = false;
                if ((this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                    if (this.poolConfiguration.getMinSize() > 0) {
                        PoolFiller.fillPool(this);
                    } else {
                        emptyManagedConnectionPool = true;
                    }
                } else {
                    emptyManagedConnectionPool = true;
                }
                if (emptyManagedConnectionPool && this.isEmpty()) {
                    this.pool.emptyManagedConnectionPool(this);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.trace) {
            this.log.tracef("Shutdown - Pool: %s MCP: %s", this.pool.getName(), Integer.toHexString(System.identityHashCode(this)));
        }
        this.shutdown.set(true);
        IdleRemover.getInstance().unregisterPool(this);
        ConnectionValidator.getInstance().unregisterPool(this);
        if (this.checkedOut.size() > 0) {
            for (ConnectionListener cl : this.checkedOut) {
                this.log.destroyingActiveConnection(this.pool.getName(), cl.getManagedConnection());
            }
        }
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillToMin() {
        if (this.poolConfiguration.getMinSize() <= 0) {
            return;
        }
        if (!this.poolConfiguration.isPrefill() && !this.poolConfiguration.isStrictMin()) {
            return;
        }
        if (!(this.pool instanceof PrefillPool)) {
            return;
        }
        while (true) {
            try {
                while (true) {
                    long startWait = System.currentTimeMillis();
                    if (!this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS)) continue;
                    this.statistics.deltaTotalBlockingTime(System.currentTimeMillis() - startWait);
                    try {
                        if (this.shutdown.get()) {
                            this.statistics.setInUsedCount(this.checkedOut.size());
                            return;
                        }
                        if (this.isSize(this.poolConfiguration.getMinSize())) {
                            this.statistics.setInUsedCount(this.checkedOut.size());
                            return;
                        }
                        try {
                            ConnectionListener cl = this.createConnectionEventListener(this.defaultSubject, this.defaultCri);
                            ArrayList<ConnectionListener> arrayList = this.cls;
                            synchronized (arrayList) {
                                if (this.trace) {
                                    this.log.trace("Filling pool cl=" + cl);
                                }
                                this.cls.add(cl);
                                this.statistics.setInUsedCount(this.checkedOut.size() + 1);
                                continue;
                            }
                        }
                        catch (ResourceException re) {
                            this.statistics.setInUsedCount(this.checkedOut.size());
                            this.log.unableFillPool(re);
                            this.permits.release();
                            return;
                        }
                    }
                    finally {
                        this.permits.release();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ignored) {
                Thread.interrupted();
                if (!this.trace) continue;
                this.log.trace("Interrupted while requesting permit in fillToMin");
                continue;
            }
            break;
        }
    }

    @Override
    public ManagedConnectionPoolStatistics getStatistics() {
        return this.statistics;
    }

    private ConnectionListener createConnectionEventListener(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        long start = System.currentTimeMillis();
        ManagedConnection mc = this.mcf.createManagedConnection(subject, cri);
        this.statistics.deltaTotalCreationTime(System.currentTimeMillis() - start);
        this.statistics.deltaCreatedCount();
        try {
            return this.clf.createConnectionListener(mc, this);
        }
        catch (ResourceException re) {
            this.statistics.deltaDestroyedCount();
            mc.destroy();
            throw re;
        }
    }

    private void doDestroy(ConnectionListener cl) {
        if (cl.getState() == ConnectionState.DESTROYED) {
            if (this.trace) {
                this.log.trace("ManagedConnection is already destroyed " + cl);
            }
            return;
        }
        this.statistics.deltaDestroyedCount();
        cl.setState(ConnectionState.DESTROYED);
        ManagedConnection mc = cl.getManagedConnection();
        try {
            mc.destroy();
        }
        catch (Throwable t) {
            this.log.debug("Exception destroying ManagedConnection " + cl, t);
        }
        mc.removeConnectionEventListener((ConnectionEventListener)cl);
    }

    private boolean shouldRemove() {
        boolean remove = true;
        if (this.poolConfiguration.isStrictMin()) {
            remove = this.isSize(this.poolConfiguration.getMinSize() + 1);
            if (this.trace) {
                this.log.trace("StrictMin is active. Current connection will be removed is " + remove);
            }
        }
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateConnections() throws Exception {
        if (this.trace) {
            this.log.trace("Attempting to  validate connections for pool " + this);
        }
        if (this.permits.tryAcquire(this.poolConfiguration.getBlockingTimeout(), TimeUnit.MILLISECONDS) == false) return;
        anyDestroyed = false;
        while (true) lbl-1000:
        // 6 sources

        {
            cl = null;
            destroyed = false;
            var4_4 = this.cls;
            synchronized (var4_4) {
                if (this.cls.size() == 0) {
                    return;
                }
                cl = this.removeForFrequencyCheck();
                ** if (cl != null) goto lbl16
            }
lbl15:
            // 1 sources

            return;
lbl16:
            // 1 sources

            try {
                candidateSet = Collections.singleton(cl.getManagedConnection());
                if (this.mcf instanceof ValidatingManagedConnectionFactory) {
                    vcf = (ValidatingManagedConnectionFactory)this.mcf;
                    if ((candidateSet = vcf.getInvalidConnections(candidateSet)) == null || candidateSet.size() <= 0 || cl.getState() == ConnectionState.DESTROY) ** GOTO lbl-1000
                    this.doDestroy(cl);
                    cl = null;
                    destroyed = true;
                    anyDestroyed = true;
                }
                this.log.backgroundValidationNonCompliantManagedConnectionFactory();
            }
            finally {
                if (destroyed) ** GOTO lbl-1000
                var4_4 = this.cls;
                synchronized (var4_4) {
                    this.returnForFrequencyCheck(cl);
                }
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        finally {
            this.permits.release();
            if (anyDestroyed && !this.shutdown.get() && this.poolConfiguration.getMinSize() > 0 && (this.poolConfiguration.isPrefill() || this.poolConfiguration.isStrictMin()) && this.pool instanceof PrefillPool) {
                PoolFiller.fillPool(this);
            }
        }
    }

    private ConnectionListener removeForFrequencyCheck() {
        this.log.debug("Checking for connection within frequency");
        ConnectionListener cl2 = null;
        for (ConnectionListener cl2 : this.cls) {
            long lastCheck = cl2.getLastValidatedTime();
            if (System.currentTimeMillis() - lastCheck >= this.poolConfiguration.getBackgroundValidationMillis()) {
                this.cls.remove(cl2);
                break;
            }
            cl2 = null;
        }
        return cl2;
    }

    private void returnForFrequencyCheck(ConnectionListener cl) {
        this.log.debug("Returning for connection within frequency");
        cl.setLastValidatedTime(System.currentTimeMillis());
        this.cls.add(cl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SemaphoreArrayListManagedConnectionPool@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[pool=").append(this.pool.getName());
        sb.append("]");
        return sb.toString();
    }
}

