/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.security.SecurityActions;
import org.jboss.jca.core.spi.security.Callback;
import org.jboss.logging.Logger;
import org.jboss.security.SimplePrincipal;

public class DefaultCallback
implements Callback {
    private static final long serialVersionUID = 1L;
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)DefaultCallback.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static final String DEFAULT_CALLBACK_PROPERTIES = "callback.properties";
    private boolean mappingRequired = false;
    private String domain = null;
    private Principal defaultPrincipal = null;
    private String[] defaultGroups = null;
    private Map<String, String> principals = new HashMap<String, String>();
    private Map<String, String> groups = new HashMap<String, String>();
    private String file;

    public DefaultCallback() {
        this(null);
    }

    public DefaultCallback(String file) {
        this.file = file;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String v) {
        this.domain = v;
    }

    public boolean isMappingRequired() {
        return this.mappingRequired;
    }

    public void setMappingRequired(boolean value) {
        this.mappingRequired = value;
    }

    public Principal getDefaultPrincipal() {
        return this.defaultPrincipal;
    }

    public void setDefaultPrincipal(Principal value) {
        this.defaultPrincipal = value;
    }

    public String[] getDefaultGroups() {
        if (this.defaultGroups == null) {
            return null;
        }
        return Arrays.copyOf(this.defaultGroups, this.defaultGroups.length);
    }

    public void setDefaultGroups(String[] value) {
        this.defaultGroups = value != null ? Arrays.copyOf(value, value.length) : null;
    }

    public Principal mapPrincipal(String name) {
        String mapping = this.principals.get(name);
        if (mapping != null) {
            return new SimplePrincipal(mapping);
        }
        return null;
    }

    public void addPrincipalMapping(String from, String to) {
        this.principals.put(from, to);
    }

    public String mapGroup(String name) {
        return this.groups.get(name);
    }

    public void addGroupMapping(String from, String to) {
        this.groups.put(from, to);
    }

    public void setFile(String value) {
        this.file = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Throwable {
        InputStream is = null;
        try {
            File f;
            if (this.file != null && (f = new File(this.file)).exists()) {
                if (trace) {
                    log.trace("callback.properties: Using file: " + this.file);
                }
                is = new FileInputStream(f);
            }
            if (is == null) {
                if (trace) {
                    log.trace("callback.properties: Using classloader");
                }
                is = SecurityActions.getResourceAsStream(DEFAULT_CALLBACK_PROPERTIES);
            }
            if (is != null) {
                Properties p = new Properties();
                p.load(is);
                if (p.size() > 0) {
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String to;
                        String from;
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if ("mapping-required".equals(key)) {
                            this.mappingRequired = Boolean.valueOf(value);
                            continue;
                        }
                        if ("domain".equals(key)) {
                            this.domain = value;
                            continue;
                        }
                        if ("default-principal".equals(key)) {
                            if (value == null || value.trim().equals("")) continue;
                            this.defaultPrincipal = new SimplePrincipal(value);
                            continue;
                        }
                        if ("default-groups".equals(key)) {
                            if (value == null || value.trim().equals("")) continue;
                            StringTokenizer st = new StringTokenizer(",");
                            ArrayList<String> groups = new ArrayList<String>();
                            while (st.hasMoreTokens()) {
                                groups.add(st.nextToken().trim());
                            }
                            this.defaultGroups = groups.toArray(new String[groups.size()]);
                            continue;
                        }
                        if (key.startsWith("map.user")) {
                            if (value == null || !value.contains("=>")) continue;
                            int index = value.indexOf("=>");
                            from = value.substring(0, index);
                            to = value.substring(index + 2);
                            this.addPrincipalMapping(from, to);
                            continue;
                        }
                        if (!key.startsWith("map.group") || value == null || !value.contains("=>")) continue;
                        int index = value.indexOf("=>");
                        from = value.substring(0, index);
                        to = value.substring(index + 2);
                        this.addGroupMapping(from, to);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Empty callback.properties file");
                }
            } else {
                log.noCallbackPropertiesFound();
            }
        }
        catch (IOException ioe) {
            log.errorWhileLoadingCallbackProperties(ioe);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void stop() throws Throwable {
        this.principals.clear();
        this.groups.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.mappingRequired);
        out.writeUTF(this.domain);
        if (this.defaultPrincipal != null) {
            out.writeBoolean(true);
            out.writeUTF(this.defaultPrincipal.getName());
        } else {
            out.writeBoolean(false);
        }
        out.writeObject(this.defaultGroups);
        out.writeInt(this.principals.size());
        if (this.principals.size() > 0) {
            for (Map.Entry<String, String> entry : this.principals.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }
        out.writeInt(this.groups.size());
        if (this.groups.size() > 0) {
            for (Map.Entry<String, String> entry : this.groups.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
        }
        out.writeUTF(this.file);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String to;
        String from;
        int j;
        this.mappingRequired = in.readBoolean();
        this.domain = in.readUTF();
        if (in.readBoolean()) {
            this.defaultPrincipal = new SimplePrincipal(in.readUTF());
        }
        this.defaultGroups = (String[])in.readObject();
        int i = in.readInt();
        if (i > 0) {
            for (j = 1; j <= i; ++j) {
                from = in.readUTF();
                to = in.readUTF();
                this.principals.put(from, to);
            }
        }
        if ((i = in.readInt()) > 0) {
            for (j = 1; j <= i; ++j) {
                from = in.readUTF();
                to = in.readUTF();
                this.groups.put(from, to);
            }
        }
        this.file = in.readUTF();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultCallback@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[mappingRequired=").append(this.mappingRequired);
        sb.append(" domain=").append(this.domain);
        sb.append(" defaultPrincipal=").append(this.defaultPrincipal);
        sb.append(" defaultGroups=").append(this.defaultGroups == null ? "null" : Arrays.toString(this.defaultGroups));
        sb.append(" principals=").append(this.principals);
        sb.append(" groups=").append(this.groups);
        sb.append(" file=").append(this.file);
        sb.append("]");
        return sb.toString();
    }
}

