/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Messages;
import org.jboss.security.SubjectFactory;

public abstract class AbstractConnectionManager
implements ConnectionManager {
    private final CoreLogger log;
    protected boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Pool pool;
    private String securityDomain;
    private SubjectFactory subjectFactory;
    private FlushStrategy flushStrategy;
    private int allocationRetry;
    private long allocationRetryWaitMillis;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private CachedConnectionManager cachedConnectionManager;
    private String jndiName;
    protected boolean connectable;

    protected AbstractConnectionManager() {
        this.log = this.getLogger();
        this.trace = this.log.isTraceEnabled();
    }

    protected abstract CoreLogger getLogger();

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    public void setCachedConnectionManager(CachedConnectionManager cachedConnectionManager) {
        this.cachedConnectionManager = cachedConnectionManager;
    }

    @Override
    public CachedConnectionManager getCachedConnectionManager() {
        return this.cachedConnectionManager;
    }

    @Override
    public void shutdown() {
        this.getLogger().debug(this.jndiName + ": shutdown");
        this.shutdown.set(true);
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    @Override
    public String getJndiName() {
        return this.jndiName;
    }

    @Override
    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public SubjectFactory getSubjectFactory() {
        return this.subjectFactory;
    }

    public void setSubjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    public FlushStrategy getFlushStrategy() {
        return this.flushStrategy;
    }

    public void setFlushStrategy(FlushStrategy v) {
        this.flushStrategy = v;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        if (this.pool == null) {
            if (this.trace) {
                this.log.trace("No pooling strategy found! for connection manager : " + this);
                return null;
            }
        } else {
            return this.pool.getManagedConnectionFactory();
        }
        return null;
    }

    public void setAllocationRetry(int number) {
        if (number >= 0) {
            this.allocationRetry = number;
        }
    }

    @Override
    public int getAllocationRetry() {
        return this.allocationRetry;
    }

    public void setAllocationRetryWaitMillis(long millis) {
        if (millis > 0L) {
            this.allocationRetryWaitMillis = millis;
        }
    }

    @Override
    public long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean v) {
        this.connectable = v;
        if (this.trace) {
            this.log.tracef("connectable=%s", this.connectable);
        }
    }

    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        return this.getManagedConnection(null, subject, cri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionListener getManagedConnection(Transaction transaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Throwable failure = null;
        if (this.shutdown.get()) {
            throw new ResourceException(bundle.connectionManagerIsShutdown(this.jndiName));
        }
        boolean isInterrupted = Thread.interrupted();
        boolean innerIsInterrupted = false;
        try {
            ConnectionListener connectionListener = this.pool.getConnection(transaction, subject, cri);
            return connectionListener;
        }
        catch (ResourceException e) {
            failure = e;
            if (this.allocationRetry != 0) {
                for (int i = 0; i < this.allocationRetry; ++i) {
                    if (this.shutdown.get()) {
                        throw new ResourceException(bundle.connectionManagerIsShutdown(this.jndiName));
                    }
                    if (this.trace) {
                        this.log.trace("Attempting allocation retry for cri=" + cri);
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                        innerIsInterrupted = true;
                    }
                    try {
                        if (this.allocationRetryWaitMillis != 0L) {
                            Thread.sleep(this.allocationRetryWaitMillis);
                        }
                        ConnectionListener connectionListener = this.pool.getConnection(transaction, subject, cri);
                        return connectionListener;
                    }
                    catch (ResourceException re) {
                        failure = re;
                        continue;
                    }
                    catch (InterruptedException ie) {
                        failure = ie;
                        innerIsInterrupted = true;
                    }
                    {
                        continue;
                    }
                }
            }
        }
        finally {
            if (isInterrupted || innerIsInterrupted) {
                Thread.currentThread().interrupt();
                if (innerIsInterrupted) {
                    throw new ResourceException(bundle.getManagedConnectionRetryWaitInterrupted(this.jndiName), failure);
                }
            }
        }
    }

    public void returnManagedConnection(org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener bcl, boolean kill) {
        ConnectionListener cl = (ConnectionListener)bcl;
        Pool localStrategy = cl.getPool();
        if (localStrategy != this.pool) {
            kill = true;
        }
        try {
            if (!kill && cl.getState().equals((Object)ConnectionState.NORMAL)) {
                cl.tidyup();
            }
        }
        catch (Throwable t) {
            this.log.errorDuringTidyUpConnection(cl, t);
            kill = true;
        }
        try {
            localStrategy.returnConnection(cl, kill);
        }
        catch (ResourceException re) {
            if (kill) {
                this.log.debug("resourceException killing connection (error retrieving from pool?)", re);
            }
            this.log.resourceExceptionReturningConnection(cl.getManagedConnection(), re);
        }
    }

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cri) throws ResourceException {
        if (this.pool == null) {
            throw new ResourceException(bundle.tryingUseConnectionFactoryShutDown());
        }
        if (!this.pool.getManagedConnectionFactory().equals(mcf)) {
            throw new ResourceException(bundle.wrongManagedConnectionFactorySentToAllocateConnection(this.pool.getManagedConnectionFactory(), mcf));
        }
        Subject subject = this.getSubject();
        ConnectionListener cl = this.getManagedConnection(subject, cri);
        this.reconnectManagedConnection(cl);
        Object connection = null;
        try {
            connection = cl.getManagedConnection().getConnection(subject, cri);
        }
        catch (Throwable t) {
            try {
                this.managedConnectionDisconnected(cl);
            }
            catch (ResourceException re) {
                if (this.trace) {
                    this.log.trace("Get exception from managedConnectionDisconnected, maybe delist() have problem" + (Object)((Object)re));
                }
                this.returnManagedConnection(cl, true);
            }
            throw new ResourceException(bundle.uncheckedThrowableInManagedConnectionGetConnection(cl), t);
        }
        this.registerAssociation(cl, connection);
        if (this.cachedConnectionManager != null) {
            this.cachedConnectionManager.registerConnection((ConnectionCacheListener)this, (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)cl, connection, cri);
        }
        return connection;
    }

    @Override
    public void disconnect(Collection<ConnectionRecord> conRecords, Set<String> unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            if (this.trace) {
                this.log.trace("disconnect for unshareable connection: nothing to do");
            }
            return;
        }
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>(conRecords.size());
        for (ConnectionRecord cr : conRecords) {
            ConnectionListener cl = cr.getConnectionListener();
            cr.setConnectionListener(null);
            this.unregisterAssociation(cl, cr.getConnection());
            if (cls.contains(cl)) continue;
            cls.add(cl);
        }
        Iterator<ConnectionRecord> i = cls.iterator();
        while (i.hasNext()) {
            this.disconnectManagedConnection((ConnectionListener)((Object)i.next()));
        }
    }

    @Override
    public void reconnect(Collection<ConnectionRecord> conns, Set<String> unsharableResources) throws ResourceException {
        if (unsharableResources.contains(this.jndiName)) {
            if (this.trace) {
                this.log.trace("reconnect for unshareable connection: nothing to do");
            }
            return;
        }
        HashMap<ConnectionRequestInfo, ConnectionListener> criToCLMap = new HashMap<ConnectionRequestInfo, ConnectionListener>(conns.size());
        for (ConnectionRecord cr : conns) {
            ConnectionListener cl;
            if (cr.getConnectionListener() != null) {
                this.log.reconnectingConnectionHandleHasManagedConnection(cr.getConnectionListener().getManagedConnection(), cr.getConnection());
            }
            if ((cl = (ConnectionListener)criToCLMap.get(cr.getCri())) == null) {
                cl = this.getManagedConnection(this.getSubject(), cr.getCri());
                criToCLMap.put(cr.getCri(), cl);
                this.reconnectManagedConnection(cl);
            }
            cl.getManagedConnection().associateConnection(cr.getConnection());
            this.registerAssociation(cl, cr.getConnection());
            cr.setConnectionListener(cl);
        }
    }

    @Override
    public void unregisterAssociation(ConnectionListener cl, Object c) {
        cl.unregisterConnection(c);
    }

    protected void reconnectManagedConnection(ConnectionListener cl) throws ResourceException {
        try {
            this.managedConnectionReconnected(cl);
        }
        catch (Throwable t) {
            this.disconnectManagedConnection(cl);
            throw new ResourceException(bundle.uncheckedThrowableInManagedConnectionReconnected(cl), t);
        }
    }

    protected void disconnectManagedConnection(ConnectionListener cl) {
        try {
            this.managedConnectionDisconnected(cl);
        }
        catch (Throwable t) {
            this.log.uncheckedThrowableInManagedConnectionDisconnected(cl, t);
        }
    }

    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
    }

    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
    }

    private void registerAssociation(ConnectionListener cl, Object c) throws ResourceException {
        cl.registerConnection(c);
    }

    @Override
    public abstract void transactionStarted(Collection<ConnectionRecord> var1) throws SystemException;

    @Override
    public abstract boolean isTransactional();

    @Override
    public abstract TransactionIntegration getTransactionIntegration();

    private Subject getSubject() {
        Set<PasswordCredential> credentials;
        Subject subject = null;
        if (this.subjectFactory != null && this.securityDomain != null && (credentials = (subject = this.subjectFactory.createSubject(this.securityDomain)).getPrivateCredentials(PasswordCredential.class)).size() > 0) {
            ManagedConnectionFactory pcMcf = this.getManagedConnectionFactory();
            for (PasswordCredential pc : credentials) {
                pc.setManagedConnectionFactory(pcMcf);
            }
        }
        if (this.trace) {
            this.log.tracef("Subject: %s", subject);
        }
        return subject;
    }
}

