/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool;

import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.RetryableException;
import javax.security.auth.Subject;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListenerFactory;
import org.jboss.jca.core.connectionmanager.pool.PoolStatisticsImpl;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolFactory;
import org.jboss.jca.core.connectionmanager.transaction.LockKey;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Messages;

public abstract class AbstractPool
implements Pool {
    protected final CoreLogger log;
    private boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private final ConcurrentMap<Object, ManagedConnectionPool> mcpPools = new ConcurrentHashMap<Object, ManagedConnectionPool>();
    private final ManagedConnectionFactory mcf;
    private ConnectionListenerFactory clf;
    private final PoolConfiguration poolConfiguration;
    private final boolean noTxSeparatePools;
    private String poolName;
    private PoolStatistics statistics;

    protected AbstractPool(ManagedConnectionFactory mcf, PoolConfiguration pc, boolean noTxSeparatePools) {
        if (mcf == null) {
            throw new IllegalArgumentException("MCF is null");
        }
        if (pc == null) {
            throw new IllegalArgumentException("PoolConfiguration is null");
        }
        this.mcf = mcf;
        this.poolConfiguration = pc;
        this.noTxSeparatePools = noTxSeparatePools;
        this.log = this.getLogger();
        this.trace = this.log.isTraceEnabled();
        this.statistics = new PoolStatisticsImpl(pc.getMaxSize(), this.mcpPools);
    }

    @Override
    public void setName(String poolName) {
        this.poolName = poolName;
    }

    public String getName() {
        return this.poolName;
    }

    protected abstract Object getKey(Subject var1, ConnectionRequestInfo var2, boolean var3) throws ResourceException;

    protected ManagedConnectionPool getManagedConnectionPool(Object key, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        try {
            ManagedConnectionPoolFactory mcpf;
            ManagedConnectionPool newMcp;
            ManagedConnectionPool mcp = (ManagedConnectionPool)this.mcpPools.get(key);
            if (mcp == null && (mcp = this.mcpPools.putIfAbsent(key, newMcp = (mcpf = new ManagedConnectionPoolFactory()).create(this.mcf, this.clf, subject, cri, this.poolConfiguration, this))) == null) {
                mcp = newMcp;
                this.initLock();
            }
            return mcp;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.unableGetManagedConnectionPool(), t);
        }
    }

    protected TransactionIntegration getTransactionIntegration() {
        if (this.clf != null) {
            return this.clf.getTransactionIntegration();
        }
        return null;
    }

    protected TransactionManager getTransactionManager() {
        if (this.getTransactionIntegration() != null) {
            return this.getTransactionIntegration().getTransactionManager();
        }
        return null;
    }

    protected TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        if (this.getTransactionIntegration() != null) {
            return this.getTransactionIntegration().getTransactionSynchronizationRegistry();
        }
        return null;
    }

    private synchronized Lock initLock() {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        if (tsr != null && tsr.getTransactionKey() != null) {
            if (tsr.getResource((Object)LockKey.INSTANCE) == null) {
                ReentrantLock lock = new ReentrantLock(true);
                tsr.putResource((Object)LockKey.INSTANCE, (Object)lock);
                return lock;
            }
            return (Lock)tsr.getResource((Object)LockKey.INSTANCE);
        }
        return null;
    }

    private Lock getLock() {
        Lock result = null;
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        if (tsr != null && tsr.getTransactionKey() != null && (result = (Lock)tsr.getResource((Object)LockKey.INSTANCE)) == null) {
            result = this.initLock();
        }
        return result;
    }

    @Override
    public synchronized void emptyManagedConnectionPool(ManagedConnectionPool pool) {
        this.log.debug(this.poolName + ": emptyManagedConnectionPool(" + pool + ")");
        if (pool != null && this.mcpPools.size() > 1) {
            Iterator it = this.mcpPools.values().iterator();
            while (it.hasNext()) {
                ManagedConnectionPool other = (ManagedConnectionPool)it.next();
                if (other != pool || !pool.isEmpty()) continue;
                pool.shutdown();
                it.remove();
                break;
            }
        }
    }

    public void flush() {
        this.flush(false);
    }

    public synchronized void flush(boolean kill) {
        this.log.debug(this.poolName + ": flush(" + kill + ")");
        HashSet<ManagedConnectionPool> clearMcpPools = new HashSet<ManagedConnectionPool>();
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            mcp.flush(kill);
            if (!mcp.isEmpty()) continue;
            clearMcpPools.add(mcp);
        }
        if (clearMcpPools.size() > 0) {
            for (ManagedConnectionPool mcp : clearMcpPools) {
                mcp.shutdown();
                this.mcpPools.values().remove(mcp);
            }
        }
    }

    @Override
    public ConnectionListener getConnection(Transaction trackByTransaction, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Object transactionKey;
        ConnectionListener cl = null;
        boolean separateNoTx = false;
        if (this.noTxSeparatePools) {
            separateNoTx = this.clf.isTransactional();
        }
        Object key = this.getKey(subject, cri, separateNoTx);
        ManagedConnectionPool mcp = this.getManagedConnectionPool(key, subject, cri);
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Object object = transactionKey = tsr != null ? tsr.getTransactionKey() : null;
        if (trackByTransaction == null || transactionKey == null) {
            return this.getSimpleConnection(subject, cri, mcp);
        }
        cl = this.getTransactionOldConnection(trackByTransaction, mcp);
        if (cl == null) {
            cl = this.getTransactionNewConnection(trackByTransaction, mcp, subject, cri);
        }
        return cl;
    }

    private ConnectionListener getSimpleConnection(Subject subject, ConnectionRequestInfo cri, ManagedConnectionPool mcp) throws ResourceException {
        ConnectionListener cl = null;
        try {
            cl = mcp.getConnection(subject, cri);
            if (this.trace) {
                this.log.tracef("Got connection from pool: %s", cl);
            }
            return cl;
        }
        catch (ResourceException re) {
            if (re instanceof RetryableException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Got a RetryableException - trying to reinitialize the pool");
                }
                if (!mcp.isRunning()) {
                    mcp.reenable();
                }
                cl = mcp.getConnection(subject, cri);
                if (this.trace) {
                    this.log.tracef("Got connection from pool (retried): %s", cl);
                }
                return cl;
            }
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionListener getTransactionOldConnection(Transaction trackByTransaction, ManagedConnectionPool mcp) throws ResourceException {
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Lock lock = this.getLock();
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
        }
        try {
            ConnectionListener cl = (ConnectionListener)tsr.getResource((Object)mcp);
            if (cl != null) {
                if (this.trace) {
                    this.log.tracef("Previous connection tracked by transaction=%s tx=%s", cl, trackByTransaction);
                }
                ConnectionListener connectionListener = cl;
                return connectionListener;
            }
            ConnectionListener connectionListener = null;
            return connectionListener;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionListener getTransactionNewConnection(Transaction trackByTransaction, ManagedConnectionPool mcp, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        ConnectionListener cl = mcp.getConnection(subject, cri);
        if (this.trace) {
            this.log.tracef("Got connection from pool tracked by transaction=%s tx=%s", cl, trackByTransaction);
        }
        TransactionSynchronizationRegistry tsr = this.getTransactionSynchronizationRegistry();
        Lock lock = this.getLock();
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
            throw new ResourceException(bundle.unableObtainLock(), (Throwable)ie);
        }
        try {
            ConnectionListener other = (ConnectionListener)tsr.getResource((Object)mcp);
            if (other != null) {
                mcp.returnConnection(cl, false);
                if (this.trace) {
                    this.log.tracef("Another thread already got a connection tracked by transaction=%s tx=%s", other, trackByTransaction);
                }
                cl = other;
            }
            cl.setTrackByTx(true);
            tsr.putResource((Object)mcp, (Object)cl);
            if (this.trace) {
                this.log.tracef("Using connection from pool tracked by transaction=%s tx=%s", cl, trackByTransaction);
            }
            ConnectionListener connectionListener = cl;
            return connectionListener;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    @Override
    public void returnConnection(ConnectionListener cl, boolean kill) throws ResourceException {
        cl.setTrackByTx(false);
        ManagedConnectionPool mcp = (ManagedConnectionPool)cl.getContext();
        mcp.returnConnection(cl, kill);
        if (this.trace) {
            this.log.tracef("Returning connection to pool %s", cl);
        }
    }

    protected ConnectionListenerFactory getConnectionListenerFactory() {
        return this.clf;
    }

    @Override
    public void setConnectionListenerFactory(ConnectionListenerFactory clf) {
        this.clf = clf;
    }

    @Override
    public void shutdown() {
        this.log.debug(this.poolName + ": shutdown");
        for (ManagedConnectionPool mcp : this.mcpPools.values()) {
            mcp.shutdown();
        }
        this.mcpPools.clear();
    }

    public PoolStatistics getStatistics() {
        return this.statistics;
    }

    public abstract boolean testConnection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean internalTestConnection(Subject subject) {
        boolean result = false;
        ConnectionListener cl = null;
        if (this.getStatistics().isEnabled()) {
            if (this.getStatistics().getAvailableCount() > 0) {
                cl = this.getConnection(null, subject, null);
                result = true;
            }
        } else {
            this.log.debug("Test connection: Statistics disabled");
        }
        if (cl == null) return result;
        try {
            this.returnConnection(cl, false);
            return result;
        }
        catch (ResourceException ire) {}
        return result;
        catch (Throwable ignored) {
            if (cl == null) return result;
            try {
                this.returnConnection(cl, false);
                return result;
            }
            catch (ResourceException ire) {}
            return result;
            catch (Throwable throwable) {
                if (cl == null) throw throwable;
                try {
                    this.returnConnection(cl, false);
                    throw throwable;
                }
                catch (ResourceException ire) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    final ConcurrentMap<Object, ManagedConnectionPool> getManagedConnectionPools() {
        return this.mcpPools;
    }

    @Override
    public abstract CoreLogger getLogger();
}

