/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.AbstractConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.listener.SecurityActions;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.transaction.TransactionSynchronizer;
import org.jboss.jca.core.connectionmanager.tx.TxConnectionManagerImpl;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class TxConnectionListener
extends AbstractConnectionListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TxConnectionListener.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private static boolean disableFailedtoEnlist = false;
    private TransactionSynchronization transactionSynchronization;
    private final XAResource xaResource;
    private final int xaResourceTimeout;
    private final AtomicBoolean localTransaction = new AtomicBoolean(false);
    private boolean killConnectionOnBoundary;

    public TxConnectionListener(ConnectionManager cm, ManagedConnection mc, Pool pool, Object context, FlushStrategy flushStrategy, XAResource xaResource, int xaResourceTimeout) throws ResourceException {
        super(cm, mc, pool, context, flushStrategy);
        String value;
        this.xaResource = xaResource;
        this.xaResourceTimeout = xaResourceTimeout;
        this.killConnectionOnBoundary = false;
        if (xaResource instanceof LocalXAResource) {
            ((LocalXAResource)xaResource).setConnectionListener((ConnectionListener)this);
        }
        if (xaResource instanceof ConnectableResource) {
            ((ConnectableResource)xaResource).setConnectableResourceListener((ConnectableResourceListener)this);
        }
        if ((value = SecurityActions.getSystemProperty("ironjacamar.kill_connection_on_boundary")) != null && !value.trim().equals("") && pool.getName().equals(value)) {
            this.killConnectionOnBoundary = true;
        }
    }

    @Override
    protected CoreLogger getLogger() {
        return log;
    }

    @Override
    public void used() {
        super.used();
        if (!(this.xaResource instanceof LocalXAResource) && this.xaResourceTimeout > 0) {
            try {
                this.xaResource.setTransactionTimeout(this.xaResourceTimeout);
            }
            catch (XAException e) {
                log.debug("XAException happend during return for: " + this.getPool().getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enlist() throws SystemException {
        TransactionManager tm = this.getConnectionManager().getTransactionIntegration().getTransactionManager();
        int status = tm.getStatus();
        if (status == 6) {
            if (this.transactionSynchronization != null && this.transactionSynchronization.currentTx != null) {
                String error = "Attempt to use connection outside a transaction when already a tx!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            if (this.trace) {
                log.trace("No transaction, no need to enlist: " + this);
            }
            return;
        }
        Transaction threadTx = tm.getTransaction();
        if (threadTx == null || status != 0) {
            String error = "Transaction " + threadTx + " is not active " + TxUtils.getStatusAsString((int)status);
            if (this.trace) {
                log.trace(error + " cl=" + this);
            }
            throw new IllegalStateException(error);
        }
        if (this.trace) {
            log.trace("Pre-enlist: " + this + " threadTx=" + threadTx);
        }
        TransactionSynchronization ourSynchronization = null;
        TransactionSynchronizer synchronizer = null;
        try {
            TransactionSynchronizer.lock(threadTx, this.getConnectionManager().getTransactionIntegration().getTransactionSynchronizationRegistry());
        }
        catch (Exception e) {
            this.setTrackByTx(false);
            TxConnectionManagerImpl.rethrowAsSystemException("Exception during lock", threadTx, e);
        }
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                String error = "Can't enlist - already a tx!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            if (this.transactionSynchronization != null && !this.transactionSynchronization.currentTx.equals(threadTx)) {
                String error = "Trying to change transaction " + threadTx + " in enlist!";
                if (this.trace) {
                    log.trace(error + " " + this);
                }
                throw new IllegalStateException(error);
            }
            try {
                if (this.trace) {
                    log.trace("Get synchronizer " + this + " threadTx=" + threadTx);
                }
                synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(threadTx, this.getConnectionManager().getTransactionIntegration().getTransactionSynchronizationRegistry());
            }
            catch (Throwable t) {
                this.setTrackByTx(false);
                TxConnectionManagerImpl.rethrowAsSystemException("Cannot register synchronization", threadTx, t);
            }
            if (this.transactionSynchronization == null) {
                TransactionSynchronization synchronization = new TransactionSynchronization(threadTx, this.isTrackByTx());
                synchronizer.addUnenlisted(synchronization);
                this.transactionSynchronization = synchronization;
            }
            ourSynchronization = this.transactionSynchronization;
        }
        finally {
            TransactionSynchronizer.unlock(threadTx);
        }
        List<Synchronization> unenlisted = synchronizer.getUnenlisted();
        if (unenlisted != null) {
            try {
                int size = unenlisted.size();
                for (int i = 0; i < size; ++i) {
                    TransactionSynchronization sync = (TransactionSynchronization)unenlisted.get(i);
                    if (!sync.enlist()) continue;
                    synchronizer.addEnlisted(sync);
                }
            }
            finally {
                synchronizer.enlisted();
            }
        }
        if (this.trace) {
            log.trace("Check enlisted " + this + " threadTx=" + threadTx);
        }
        ourSynchronization.checkEnlisted();
    }

    @Override
    public void delist() throws ResourceException {
        if (this.trace) {
            log.trace("delisting " + this);
        }
        try {
            if (!this.isTrackByTx() && this.transactionSynchronization != null) {
                Transaction tx = this.transactionSynchronization.currentTx;
                TransactionSynchronization synchronization = this.transactionSynchronization;
                this.transactionSynchronization = null;
                if (TxUtils.isUncommitted((Transaction)tx)) {
                    boolean suspendResult;
                    TransactionSynchronizer synchronizer;
                    if (synchronization.enlisted && !(synchronizer = TransactionSynchronizer.getRegisteredSynchronizer(tx, this.getConnectionManager().getTransactionIntegration().getTransactionSynchronizationRegistry())).removeEnlisted(synchronization) && this.trace) {
                        log.tracef("%s not found in %s", synchronization, synchronizer);
                    }
                    if (this.trace) {
                        log.tracef("delistResource(%s, TMSUSPEND)", this.getXAResource());
                    }
                    if (!(suspendResult = tx.delistResource(this.getXAResource(), 0x2000000))) {
                        throw new ResourceException(bundle.failureDelistResource(this));
                    }
                    if (this.trace) {
                        log.trace("delist-suspend " + this);
                    }
                }
            }
            if (this.trace) {
                log.trace("delisted " + this);
            }
        }
        catch (ResourceException re) {
            throw re;
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorInDelist(), t);
        }
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public void connectionClosed(ConnectionEvent ce) {
        if (this.trace) {
            log.trace("connectionClosed called mc=" + this.getManagedConnection());
        }
        if (this.getManagedConnection() != (ManagedConnection)ce.getSource()) {
            throw new IllegalArgumentException("ConnectionClosed event received from wrong ManagedConnection! Expected: " + this.getManagedConnection() + ", actual: " + ce.getSource());
        }
        if (this.getCachedConnectionManager() != null) {
            try {
                this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this.getConnectionManager(), ce.getConnectionHandle());
            }
            catch (Throwable t) {
                log.throwableFromUnregisterConnection(t);
            }
        }
        try {
            if (this.wasFreed(ce.getConnectionHandle())) {
                this.delist();
                if (this.trace) {
                    log.trace("isManagedConnectionFree=true mc=" + this.getManagedConnection());
                }
                this.getConnectionManager().returnManagedConnection(this, false);
            } else if (this.trace) {
                log.trace("isManagedConnectionFree=false mc=" + this.getManagedConnection());
            }
        }
        catch (Throwable t) {
            log.errorWhileClosingConnectionHandle(t);
            this.getConnectionManager().returnManagedConnection(this, true);
        }
    }

    @Override
    public void localTransactionStarted(ConnectionEvent ce) {
        this.localTransaction.set(true);
    }

    @Override
    public void localTransactionCommitted(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void localTransactionRolledback(ConnectionEvent ce) {
        this.localTransaction.set(false);
    }

    @Override
    public void tidyup() throws ResourceException {
        if (this.localTransaction.get()) {
            LocalTransaction local = null;
            ManagedConnection mc = this.getManagedConnection();
            try {
                local = mc.getLocalTransaction();
            }
            catch (Throwable t) {
                throw new ResourceException(bundle.unfinishedLocalTransaction(this), t);
            }
            if (local == null) {
                throw new ResourceException(bundle.unfinishedLocalTransactionNotProvideLocalTransaction(this));
            }
            local.rollback();
            log.debug("Unfinished local transaction was rolled back." + this);
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent ce) {
        this.transactionSynchronization = null;
        super.connectionErrorOccurred(ce);
    }

    @Override
    public boolean isManagedConnectionFree() {
        if (this.isTrackByTx() && this.transactionSynchronization != null) {
            return false;
        }
        return super.isManagedConnectionFree();
    }

    synchronized boolean wasFreed(Object handle) {
        if (handle != null) {
            if (this.isManagedConnectionFree()) {
                return false;
            }
            this.getConnectionManager().unregisterAssociation(this, handle);
        } else {
            if (!this.isTrackByTx()) {
                return false;
            }
            this.setTrackByTx(false);
        }
        return this.isManagedConnectionFree();
    }

    @Override
    protected void toString(StringBuffer buffer) {
        buffer.append(" xaResource=").append(this.xaResource);
        buffer.append(" txSync=").append(this.transactionSynchronization);
    }

    final TransactionSynchronization getTransactionSynchronization() {
        return this.transactionSynchronization;
    }

    final void setTransactionSynchronization(TransactionSynchronization transactionSynchronization) {
        this.transactionSynchronization = transactionSynchronization;
    }

    static {
        String value = SecurityActions.getSystemProperty("ironjacamar.disable_enlistment_trace");
        if (value != null && !value.trim().equals("")) {
            try {
                int equal = value.indexOf("=");
                if (equal != -1) {
                    String setting = value.substring(equal + 1);
                    disableFailedtoEnlist = Boolean.valueOf(setting);
                } else {
                    disableFailedtoEnlist = true;
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to parse ironjacamar.disable_enlistment_trace: " + value);
            }
        }
    }

    public class TransactionSynchronization
    implements Synchronization {
        private final Throwable failedToEnlist;
        protected final Transaction currentTx;
        private final boolean wasTrackByTx;
        private boolean enlisted;
        private Throwable enlistError;

        public TransactionSynchronization(Transaction tx, boolean trackByTx) {
            this.currentTx = tx;
            this.wasTrackByTx = trackByTx;
            this.enlisted = false;
            this.enlistError = null;
            this.failedToEnlist = !disableFailedtoEnlist ? new Throwable("Unabled to enlist resource, see the previous warnings.") : null;
        }

        public void checkEnlisted() throws SystemException {
            if (this.enlistError != null) {
                String error = "Error enlisting resource in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    log.trace(error + " " + TxConnectionListener.this);
                }
                if (!disableFailedtoEnlist && this.enlistError == this.failedToEnlist) {
                    throw new SystemException(bundle.systemExceptionWhenFailedToEnlistEqualsCurrentTx(this.failedToEnlist, this.currentTx));
                }
                SystemException e = new SystemException(error);
                e.initCause(this.enlistError);
                throw e;
            }
            if (!this.enlisted) {
                String error = "Resource is not enlisted in transaction=" + this.currentTx;
                if (TxConnectionListener.this.trace) {
                    log.trace(error + " " + TxConnectionListener.this);
                }
                throw new IllegalStateException("Resource was not enlisted.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean enlist() {
            if (TxConnectionListener.this.trace) {
                log.trace("Enlisting resource " + TxConnectionListener.this);
            }
            try {
                XAResource resource = TxConnectionListener.this.getXAResource();
                if (!this.currentTx.enlistResource(resource)) {
                    this.enlistError = !disableFailedtoEnlist ? this.failedToEnlist : new Throwable("Failed to enlist");
                }
            }
            catch (Throwable t) {
                this.enlistError = t;
            }
            TransactionSynchronization transactionSynchronization = this;
            synchronized (transactionSynchronization) {
                if (this.enlistError != null) {
                    if (TxConnectionListener.this.trace) {
                        log.trace("Failed to enlist resource " + TxConnectionListener.this, this.enlistError);
                    }
                    TxConnectionListener.this.setTrackByTx(false);
                    TxConnectionListener.this.transactionSynchronization = null;
                    return false;
                }
                this.enlisted = true;
                if (TxConnectionListener.this.trace) {
                    log.trace("Enlisted resource " + TxConnectionListener.this);
                }
                return true;
            }
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (TxConnectionListener.this.getState().equals((Object)ConnectionState.DESTROYED)) {
                return;
            }
            if (!this.equals(TxConnectionListener.this.transactionSynchronization)) {
                if (!this.wasTrackByTx) {
                    return;
                }
                String message = "afterCompletion called with wrong tx! Expected: " + this + ", actual: " + TxConnectionListener.this.transactionSynchronization;
                IllegalStateException e = new IllegalStateException(message);
                log.somethingWrongWithPooling(e);
            }
            TxConnectionListener.this.transactionSynchronization = null;
            if (this.wasTrackByTx) {
                if (TxConnectionListener.this.trace) {
                    log.trace("afterCompletion(" + status + ") isTrackByTx=" + TxConnectionListener.this.isTrackByTx() + " for " + TxConnectionListener.this);
                }
                if (TxConnectionListener.this.wasFreed(null)) {
                    TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, false);
                } else if (TxConnectionListener.this.killConnectionOnBoundary) {
                    log.activeHandles(TxConnectionListener.this.getPool() != null ? TxConnectionListener.this.getPool().getName() : "Unknown", TxConnectionListener.this.connectionHandles.size());
                    TxConnectionListener.this.getConnectionManager().returnManagedConnection(TxConnectionListener.this, true);
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("TxSync@").append(System.identityHashCode(this));
            buffer.append("{tx=").append(this.currentTx);
            buffer.append(" wasTrackByTx=").append(this.wasTrackByTx);
            buffer.append(" enlisted=").append(this.enlisted);
            buffer.append("}");
            return buffer.toString();
        }
    }
}

