/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.jbossts;

import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.spi.transaction.local.LocalXAException;
import org.jboss.jca.core.spi.transaction.local.LocalXAResource;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jboss.tm.LastResource;

public class LocalXAResourceImpl
implements LocalXAResource,
LastResource {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)LocalXAResourceImpl.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private ConnectionListener cl;
    private ConnectionManager connectionManager = null;
    private boolean warned = false;
    private Xid currentXid;

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void setConnectionListener(ConnectionListener cl) {
        this.cl = cl;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            log.tracef("start(%s, %s)", xid, flags);
        }
        if (this.currentXid != null && flags == 0) {
            throw new LocalXAException(bundle.tryingStartNewTxWhenOldNotComplete(this.currentXid, xid, flags), -6);
        }
        if (this.currentXid == null && flags != 0) {
            throw new LocalXAException(bundle.tryingStartNewTxWithWrongFlags(xid, flags), -6);
        }
        if (this.currentXid == null) {
            try {
                this.cl.getManagedConnection().getLocalTransaction().begin();
            }
            catch (ResourceException re) {
                throw new LocalXAException(bundle.errorTryingStartLocalTx(), -3, (Throwable)re);
            }
            catch (Throwable t) {
                throw new LocalXAException(bundle.throwableTryingStartLocalTx(), -3, t);
            }
            this.currentXid = xid;
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            log.tracef("end(%s,%s)", xid, flags);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException(bundle.wrongXidInCommit(this.currentXid, xid), -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().commit();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotCommitLocalTx(), 100, (Throwable)re);
        }
    }

    public void forget(Xid xid) throws XAException {
        throw new LocalXAException(bundle.forgetNotSupportedInLocalTx(), -3);
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource == this;
    }

    public int prepare(Xid xid) throws XAException {
        if (!this.warned) {
            log.prepareCalledOnLocaltx();
        }
        this.warned = true;
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        throw new LocalXAException(bundle.noRecoverWithLocalTxResourceManagers(), -3);
    }

    public void rollback(Xid xid) throws XAException {
        if (!xid.equals(this.currentXid)) {
            throw new LocalXAException(bundle.wrongXidInRollback(this.currentXid, xid), -6);
        }
        this.currentXid = null;
        try {
            this.cl.getManagedConnection().getLocalTransaction().rollback();
        }
        catch (ResourceException re) {
            this.connectionManager.returnManagedConnection(this.cl, true);
            throw new LocalXAException(bundle.couldNotRollbackLocalTx(), -3, (Throwable)re);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LocalXAResourceImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[connectionListener=").append(this.cl != null ? Integer.toHexString(System.identityHashCode(this.cl)) : "null");
        sb.append(" connectionManager=").append(this.connectionManager != null ? Integer.toHexString(System.identityHashCode(this.connectionManager)) : "null");
        sb.append(" warned=").append(this.warned);
        sb.append(" currentXid=").append(this.currentXid);
        sb.append("]");
        return sb.toString();
    }
}

