/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.io.Serializable;
import java.util.Arrays;

public class ClassDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private long svu;
    private byte[] data;

    public ClassDefinition(String name, long serialVersionUID, byte[] data) {
        this.name = name;
        this.svu = serialVersionUID;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.svu;
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    public int hashCode() {
        int result = 17;
        result += 7 * this.name.hashCode();
        result = (int)((long)result + 7L * this.svu);
        return result += 7 * Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClassDefinition)) {
            return false;
        }
        ClassDefinition cd = (ClassDefinition)other;
        if (!this.name.equals(cd.name)) {
            return false;
        }
        if (this.svu != cd.svu) {
            return false;
        }
        return Arrays.equals(this.data, cd.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassDefinition@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[name=").append(this.name);
        sb.append(" serialVersionUID=").append(this.svu);
        sb.append(" data=").append(Arrays.toString(this.data));
        sb.append("]");
        return sb.toString();
    }
}

