/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.transport.remote.jgroups;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.work.DistributableWork;
import javax.resource.spi.work.WorkException;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.workmanager.ClassBundle;
import org.jboss.jca.core.workmanager.WorkClassLoader;
import org.jboss.jca.core.workmanager.WorkObjectInputStream;
import org.jboss.jca.core.workmanager.transport.remote.AbstractRemoteTransport;
import org.jboss.jca.core.workmanager.transport.remote.ProtocolMessages;
import org.jboss.jca.core.workmanager.transport.remote.jgroups.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsTransport
extends AbstractRemoteTransport<Address>
implements MembershipListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)JGroupsTransport.class.getName());
    private static boolean trace = log.isTraceEnabled();
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private JChannel channel = null;
    private long timeout = 10000L;
    private String clusterName = null;
    private RpcDispatcher disp = null;
    private boolean initialized = false;
    private static final short JOIN_METHOD = 1;
    private static final short LEAVE_METHOD = 2;
    private static final short PING_METHOD = 3;
    private static final short GET_WORKMANAGERS_METHOD = 4;
    private static final short WORKMANAGER_ADD_METHOD = 5;
    private static final short WORKMANAGER_REMOVE_METHOD = 6;
    private static final short DO_WORK_METHOD = 7;
    private static final short START_WORK_METHOD = 8;
    private static final short SCHEDULE_WORK_METHOD = 9;
    private static final short GET_SHORTRUNNING_FREE_METHOD = 10;
    private static final short GET_LONGRUNNING_FREE_METHOD = 11;
    private static final short UPDATE_SHORTRUNNING_FREE_METHOD = 12;
    private static final short UPDATE_LONGRUNNING_FREE_METHOD = 13;
    private static final short GET_DISTRIBUTED_STATISTICS_METHOD = 14;
    private static final short CLEAR_DISTRIBUTED_STATISTICS_METHOD = 15;
    private static final short DELTA_DOWORK_ACCEPTED_METHOD = 16;
    private static final short DELTA_DOWORK_REJECTED_METHOD = 17;
    private static final short DELTA_STARTWORK_ACCEPTED_METHOD = 18;
    private static final short DELTA_STARTWORK_REJECTED_METHOD = 19;
    private static final short DELTA_SCHEDULEWORK_ACCEPTED_METHOD = 20;
    private static final short DELTA_SCHEDULEWORK_REJECTED_METHOD = 21;
    private static final short DELTA_WORK_SUCCESSFUL_METHOD = 22;
    private static final short DELTA_WORK_FAILED_METHOD = 23;
    private static Map<Short, Method> methods = new HashMap<Short, Method>();

    @Override
    public void join(org.jboss.jca.core.spi.workmanager.Address logicalAddress, Address address) {
        super.join(logicalAddress, address);
    }

    @Override
    public void leave(Address address) {
        super.leave(address);
    }

    public Set<org.jboss.jca.core.spi.workmanager.Address> getWorkManagers() {
        return this.getAddresses(this.channel.getAddress());
    }

    public void addWorkManager(org.jboss.jca.core.spi.workmanager.Address logicalAddress, Address address) {
        super.localWorkManagerAdd(logicalAddress, address);
    }

    public void executeDoWork(org.jboss.jca.core.spi.workmanager.Address logicalAddress, ClassBundle classBundle, byte[] b) throws WorkException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(classBundle);
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            this.localDoWork(logicalAddress, dw);
        }
        catch (WorkException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WorkException("Error during doWork: " + t.getMessage(), t);
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public long executeStartWork(org.jboss.jca.core.spi.workmanager.Address logicalAddress, ClassBundle classBundle, byte[] b) throws WorkException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(classBundle);
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            long l = this.localStartWork(logicalAddress, dw);
            return l;
        }
        catch (WorkException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WorkException("Error during doWork: " + t.getMessage(), t);
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void executeScheduleWork(org.jboss.jca.core.spi.workmanager.Address logicalAddress, ClassBundle classBundle, byte[] b) throws WorkException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(classBundle);
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            this.localScheduleWork(logicalAddress, dw);
        }
        catch (WorkException we) {
            throw we;
        }
        catch (Throwable t) {
            throw new WorkException("Error during doWork: " + t.getMessage(), t);
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void startup() throws Throwable {
        this.disp = new RpcDispatcher((Channel)this.channel, null, (MembershipListener)this, (Object)this);
        this.disp.setMethodLookup(new MethodLookup(){

            public Method findMethod(short key) {
                return (Method)methods.get(key);
            }
        });
        if (this.clusterName == null) {
            this.clusterName = "jca";
        }
        this.channel.connect(this.clusterName);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() throws Throwable {
        this.initialized = true;
    }

    public void shutdown() throws Throwable {
        if (this.disp != null) {
            block8: {
                try {
                    this.disp.stop();
                }
                catch (Throwable t) {
                    if (!trace) break block8;
                    log.tracef("Throwable during disp.stop(): %s", t.getMessage());
                }
            }
            this.disp = null;
        }
        if (this.channel != null) {
            block10: {
                block9: {
                    try {
                        this.channel.disconnect();
                    }
                    catch (Throwable t) {
                        if (!trace) break block9;
                        log.tracef("Throwable during channel.disconnect(): %s", t.getMessage());
                    }
                }
                try {
                    this.channel.close();
                }
                catch (Throwable t) {
                    if (!trace) break block10;
                    log.tracef("Throwable during channel.close(): %s", t.getMessage());
                }
            }
            this.channel = null;
        }
    }

    @Override
    public Serializable sendMessage(Address destAddress, ProtocolMessages.Request request, Serializable ... parameters) throws WorkException {
        Serializable returnValue = null;
        if (trace) {
            log.tracef("%s: sending message=%s to %s", this.channel.getAddressAsString(), (Object)request, destAddress);
        }
        if (this.channel == null || !this.channel.isOpen() || !this.channel.isConnected()) {
            if (trace) {
                log.tracef("%s: channel not connected", this.channel != null ? this.channel.getAddressAsString() : "<empty>");
            }
            return null;
        }
        RequestOptions opts = new RequestOptions(ResponseMode.GET_ALL, this.timeout);
        try {
            switch (request) {
                case JOIN: {
                    Address joiningAddress = (Address)parameters[0];
                    List<Address> dests = destAddress == null ? null : Arrays.asList(destAddress);
                    RspList rspList = this.disp.callRemoteMethods(dests, new MethodCall(1, new Object[]{joiningAddress}), opts);
                    this.throwWorkExceptionIfHasExption((RspList<ProtocolMessages.ResponseValues>)rspList);
                    break;
                }
                case LEAVE: {
                    Address leavingAddress = (Address)parameters[0];
                    List<Address> dests = destAddress == null ? null : Arrays.asList(destAddress);
                    RspList rspList = this.disp.callRemoteMethods(dests, new MethodCall(2, new Object[]{leavingAddress}), opts);
                    this.throwWorkExceptionIfHasExption((RspList<ProtocolMessages.ResponseValues>)rspList);
                    break;
                }
                case GET_WORKMANAGERS: {
                    try {
                        returnValue = (Serializable)this.disp.callRemoteMethod(destAddress, new MethodCall(4, new Object[0]), opts);
                        break;
                    }
                    catch (WorkException we) {
                        throw we;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case WORKMANAGER_ADD: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    Address physicalAddress = (Address)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(5, new Object[]{address, physicalAddress}), opts);
                    break;
                }
                case WORKMANAGER_REMOVE: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(6, new Object[]{address}), opts);
                    break;
                }
                case PING: {
                    try {
                        returnValue = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(3, new Object[0]), opts);
                        break;
                    }
                    catch (WorkException we) {
                        throw we;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case DO_WORK: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    ClassBundle cb = (ClassBundle)parameters[1];
                    DistributableWork work = (DistributableWork)parameters[2];
                    try {
                        this.disp.callRemoteMethod(destAddress, new MethodCall(7, new Object[]{address, cb, this.getBytes(work)}), opts);
                        break;
                    }
                    catch (WorkException we) {
                        throw we;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case START_WORK: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    ClassBundle cb = (ClassBundle)parameters[1];
                    DistributableWork work = (DistributableWork)parameters[2];
                    returnValue = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(8, new Object[]{address, cb, this.getBytes(work)}), opts);
                    break;
                }
                case SCHEDULE_WORK: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    ClassBundle cb = (ClassBundle)parameters[1];
                    DistributableWork work = (DistributableWork)parameters[2];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(9, new Object[]{address, cb, this.getBytes(work)}), opts);
                    break;
                }
                case GET_SHORTRUNNING_FREE: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    returnValue = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(10, new Object[]{address}), opts);
                    break;
                }
                case GET_LONGRUNNING_FREE: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    returnValue = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(11, new Object[]{address}), opts);
                    break;
                }
                case UPDATE_SHORTRUNNING_FREE: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    Long freeCount = (Long)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(12, new Object[]{address, freeCount}), opts);
                    break;
                }
                case UPDATE_LONGRUNNING_FREE: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    Long freeCount = (Long)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(13, new Object[]{address, freeCount}), opts);
                    break;
                }
                case GET_DISTRIBUTED_STATISTICS: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    returnValue = (Serializable)this.disp.callRemoteMethod(destAddress, new MethodCall(14, new Object[]{address}), opts);
                    break;
                }
                case CLEAR_DISTRIBUTED_STATISTICS: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(15, new Object[]{address}), opts);
                    break;
                }
                case DELTA_DOWORK_ACCEPTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(16, new Object[]{address}), opts);
                    break;
                }
                case DELTA_DOWORK_REJECTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(17, new Object[]{address}), opts);
                    break;
                }
                case DELTA_STARTWORK_ACCEPTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(18, new Object[]{address}), opts);
                    break;
                }
                case DELTA_STARTWORK_REJECTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(19, new Object[]{address}), opts);
                    break;
                }
                case DELTA_SCHEDULEWORK_ACCEPTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(20, new Object[]{address}), opts);
                    break;
                }
                case DELTA_SCHEDULEWORK_REJECTED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(21, new Object[]{address}), opts);
                    break;
                }
                case DELTA_WORK_SUCCESSFUL: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(22, new Object[]{address}), opts);
                    break;
                }
                case DELTA_WORK_FAILED: {
                    org.jboss.jca.core.spi.workmanager.Address address = (org.jboss.jca.core.spi.workmanager.Address)parameters[0];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(23, new Object[]{address}), opts);
                    break;
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown command received on socket Transport");
                    }
                    break;
                }
            }
        }
        catch (WorkException we) {
            throw we;
        }
        catch (Throwable t) {
            WorkException we = new WorkException(t.getMessage());
            we.initCause(t);
            throw we;
        }
        return returnValue;
    }

    private void throwWorkExceptionIfHasExption(RspList<ProtocolMessages.ResponseValues> rspList) throws WorkException {
        if (rspList != null && rspList.getFirst() != null) {
            for (Rsp rsp : rspList) {
                if (!rsp.hasException()) continue;
                Throwable t = rsp.getException();
                if (t instanceof WorkException) {
                    throw (WorkException)t;
                }
                WorkException we = new WorkException(rsp.getException().getMessage());
                we.initCause(rsp.getException());
                throw we;
            }
        }
    }

    @Override
    public Address getOwnAddress() {
        return this.channel.getAddress();
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public void setChannel(JChannel channel) {
        this.channel = channel;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clustername) {
        this.clusterName = clustername;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long v) {
        this.timeout = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        if (trace) {
            log.tracef("java.net.preferIPv4Stack=%s", SecurityActions.getSystemProperty("java.net.preferIPv4Stack"));
            log.tracef("viewAccepted called w/ View=%s", view);
        }
        JGroupsTransport jGroupsTransport = this;
        synchronized (jGroupsTransport) {
            for (Address physicalAddress : this.nodes.values()) {
                if (physicalAddress == null || view.containsMember(physicalAddress)) continue;
                this.leave(physicalAddress);
            }
            for (Address address : view.getMembers()) {
                if (this.channel == null || this.channel.getAddress().equals(address) || this.nodes.containsValue(address)) continue;
                try {
                    Set logicalAddresses = (Set)((Object)this.sendMessage(address, ProtocolMessages.Request.GET_WORKMANAGERS, new Serializable[0]));
                    if (logicalAddresses == null || logicalAddresses.size() <= 0) continue;
                    for (org.jboss.jca.core.spi.workmanager.Address logicalAddress : logicalAddresses) {
                        this.join(logicalAddress, address);
                        Long shortRunning = this.getShortRunningFree(logicalAddress);
                        Long longRunning = this.getLongRunningFree(logicalAddress);
                        this.localUpdateShortRunningFree(logicalAddress, shortRunning);
                        this.localUpdateLongRunningFree(logicalAddress, longRunning);
                    }
                }
                catch (Throwable t) {
                    log.error("ViewAccepted: " + t.getMessage(), t);
                }
            }
        }
    }

    public void block() {
        if (trace) {
            log.tracef("block called", new Object[0]);
        }
    }

    public void suspect(Address address) {
        if (trace) {
            log.tracef("suspect called w/ Address=%s", address);
        }
    }

    public void unblock() {
        if (trace) {
            log.tracef("unblock called", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(DistributableWork dw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(dw);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            log.error("Error during getBytes: " + t.getMessage(), t);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    public String toString() {
        return "JGroupsTransport [channel=" + this.channel + ", clustername=" + this.clusterName + "]";
    }

    static {
        try {
            methods.put((short)1, JGroupsTransport.class.getMethod("join", org.jboss.jca.core.spi.workmanager.Address.class, Address.class));
            methods.put((short)2, JGroupsTransport.class.getMethod("leave", Address.class));
            methods.put((short)3, AbstractRemoteTransport.class.getMethod("localPing", new Class[0]));
            methods.put((short)4, JGroupsTransport.class.getMethod("getWorkManagers", new Class[0]));
            methods.put((short)5, JGroupsTransport.class.getMethod("addWorkManager", org.jboss.jca.core.spi.workmanager.Address.class, Address.class));
            methods.put((short)6, AbstractRemoteTransport.class.getMethod("localWorkManagerRemove", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)7, JGroupsTransport.class.getMethod("executeDoWork", org.jboss.jca.core.spi.workmanager.Address.class, ClassBundle.class, byte[].class));
            methods.put((short)8, JGroupsTransport.class.getMethod("executeStartWork", org.jboss.jca.core.spi.workmanager.Address.class, ClassBundle.class, byte[].class));
            methods.put((short)9, JGroupsTransport.class.getMethod("executeScheduleWork", org.jboss.jca.core.spi.workmanager.Address.class, ClassBundle.class, byte[].class));
            methods.put((short)10, AbstractRemoteTransport.class.getMethod("localGetShortRunningFree", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)11, AbstractRemoteTransport.class.getMethod("localGetLongRunningFree", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)12, AbstractRemoteTransport.class.getMethod("localUpdateShortRunningFree", org.jboss.jca.core.spi.workmanager.Address.class, Long.class));
            methods.put((short)13, AbstractRemoteTransport.class.getMethod("localUpdateLongRunningFree", org.jboss.jca.core.spi.workmanager.Address.class, Long.class));
            methods.put((short)14, AbstractRemoteTransport.class.getMethod("localGetDistributedStatistics", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)15, AbstractRemoteTransport.class.getMethod("localClearDistributedStatistics", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)16, AbstractRemoteTransport.class.getMethod("localDeltaDoWorkAccepted", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)17, AbstractRemoteTransport.class.getMethod("localDeltaDoWorkRejected", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)18, AbstractRemoteTransport.class.getMethod("localDeltaStartWorkAccepted", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)19, AbstractRemoteTransport.class.getMethod("localDeltaStartWorkRejected", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)20, AbstractRemoteTransport.class.getMethod("localDeltaScheduleWorkAccepted", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)21, AbstractRemoteTransport.class.getMethod("localDeltaScheduleWorkRejected", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)22, AbstractRemoteTransport.class.getMethod("localDeltaWorkSuccessful", org.jboss.jca.core.spi.workmanager.Address.class));
            methods.put((short)23, AbstractRemoteTransport.class.getMethod("localDeltaWorkFailed", org.jboss.jca.core.spi.workmanager.Address.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

