/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.novendor;

import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.extensions.novendor.JDBC4ValidConnectionChecker;
import org.jboss.jca.adapters.jdbc.util.LRUCache;

public class GoodForSecondsValidConnectionChecker
extends JDBC4ValidConnectionChecker {
    private int goodForSeconds = 5;
    private int maxKeepSize = 20;
    private LRUCache<Integer, Long> cache = null;

    @Override
    public SQLException isValidConnection(Connection c) {
        if (this.cache == null) {
            this.cache = new LRUCache(this.maxKeepSize);
        }
        long now = System.currentTimeMillis();
        Integer identifier = System.identityHashCode(c);
        Long lastChecked = this.cache.get(identifier);
        if (lastChecked != null && lastChecked + (long)this.goodForSeconds * 60000L < now) {
            return null;
        }
        SQLException result = super.isValidConnection(c);
        if (result == null) {
            this.cache.insert(identifier, now);
        } else {
            this.cache.remove(identifier);
        }
        return result;
    }

    public void setGoodForSeconds(int v) {
        this.goodForSeconds = v;
    }

    public void setMaxKeepSize(int v) {
        this.maxKeepSize = v;
    }
}

