/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.jdk8;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedPreparedStatement;
import org.jboss.jca.adapters.jdbc.WrappedResultSet;
import org.jboss.jca.adapters.jdbc.jdk8.WrappedConnectionJDK8;
import org.jboss.jca.adapters.jdbc.jdk8.WrappedResultSetJDK8;

public class WrappedPreparedStatementJDK8
extends WrappedPreparedStatement {
    private static final long serialVersionUID = 1L;

    public WrappedPreparedStatementJDK8(WrappedConnectionJDK8 lc, PreparedStatement s, boolean spy, String jndiName, boolean doLocking) {
        super((WrappedConnection)lc, s, spy, jndiName, doLocking);
    }

    @Override
    protected WrappedResultSet wrapResultSet(ResultSet resultSet, boolean spy, String jndiName, boolean doLocking) {
        return new WrappedResultSetJDK8(this, resultSet, spy, jndiName, doLocking);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLargeUpdateCount()", (Object)this.jndiName, (Object)this.spyLoggingCategory);
                }
                long l = this.getWrappedObject().getLargeUpdateCount();
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setLargeMaxRows(%d)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)max);
                }
                this.getWrappedObject().setLargeMaxRows(max);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getLargeMaxRows()", (Object)this.jndiName, (Object)this.spyLoggingCategory);
                }
                long l = this.getWrappedObject().getLargeMaxRows();
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeBatch()", (Object)this.jndiName, (Object)this.spyLoggingCategory);
                }
                long[] lArray = this.getWrappedObject().executeLargeBatch();
                return lArray;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeUpdate(%s)", (Object)this.jndiName, (Object)this.spyLoggingCategory, (Object)sql);
                }
                long l = this.getWrappedObject().executeLargeUpdate(sql);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeUpdate(%s, %d)", new Object[]{this.jndiName, this.spyLoggingCategory, sql, autoGeneratedKeys});
                }
                long l = this.getWrappedObject().executeLargeUpdate(sql, autoGeneratedKeys);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeUpdate(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, sql, columnIndexes});
                }
                long l = this.getWrappedObject().executeLargeUpdate(sql, columnIndexes);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeUpdate(%s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, sql, columnNames});
                }
                long l = this.getWrappedObject().executeLargeUpdate(sql, columnNames);
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%d, %s, %s, %d)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, x, targetSqlType, scaleOrLength});
                }
                this.getWrappedObject().setObject(parameterIndex, x, targetSqlType, scaleOrLength);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkState();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setObject(%d, %s, %s)", new Object[]{this.jndiName, this.spyLoggingCategory, parameterIndex, x, targetSqlType});
                }
                this.getWrappedObject().setObject(parameterIndex, x, targetSqlType);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        if (this.doLocking) {
            this.lock();
        }
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] executeLargeUpdate()", (Object)this.jndiName, (Object)this.spyLoggingCategory);
                }
                long l = this.getWrappedObject().executeLargeUpdate();
                return l;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            if (this.doLocking) {
                this.unlock();
            }
        }
    }
}

