/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.io.DataInput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.concurrent.CountDownLatch;
import org.jboss.ejb.client.Logs;
import org.jboss.ejb.client.remoting.NoFlushDataOutputStream;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.logging.Logger;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.xnio.IoUtils;

class VersionReceiver
implements Channel.Receiver {
    private static final Logger logger = Logger.getLogger(VersionReceiver.class);
    private final CountDownLatch latch;
    private Channel compatibleChannel;
    private boolean compatibilityFailed;
    private volatile int negotiatedVersion = -1;

    VersionReceiver(CountDownLatch latch) {
        this.latch = latch;
        this.compatibilityFailed = false;
    }

    public void handleError(Channel channel, IOException error) {
        logger.error((Object)("Error on channel " + channel), (Throwable)error);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleEnd(Channel channel) {
        Logs.REMOTING.channelCanNoLongerProcessMessages(channel);
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Channel channel, MessageInputStream message) {
        HashSet<String> serverMarshallerStrategies;
        int serverVersion;
        SimpleDataInput simpleDataInput = new SimpleDataInput(Marshalling.createByteInput((InputStream)message));
        try {
            serverVersion = simpleDataInput.readUnsignedByte();
            int serverMarshallerCount = PackedInteger.readPackedInteger((DataInput)simpleDataInput);
            if (serverMarshallerCount <= 0) {
                throw new RuntimeException("Client cannot communicate with the server since no marshalling strategy has been configured on server side");
            }
            serverMarshallerStrategies = new HashSet<String>(serverMarshallerCount, 0.5f);
            for (int i = 0; i < serverMarshallerCount; ++i) {
                serverMarshallerStrategies.add(simpleDataInput.readUTF());
            }
            Logs.REMOTING.receivedServerVersionAndMarshallingStrategies(serverVersion, serverMarshallerStrategies);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!serverMarshallerStrategies.contains("river")) {
            logger.error((Object)"Server doesn't support marshaling strategy: river");
            this.compatibilityFailed = true;
            return;
        }
        this.negotiatedVersion = Math.min(serverVersion, 2);
        try {
            MessageOutputStream channelOutputStream = channel.writeMessage();
            try {
                NoFlushDataOutputStream dataOutputStream = new NoFlushDataOutputStream((OutputStream)channelOutputStream);
                try {
                    dataOutputStream.write(this.negotiatedVersion);
                    dataOutputStream.writeUTF("river");
                    ((FilterOutputStream)dataOutputStream).close();
                }
                finally {
                    IoUtils.safeClose((Closeable)dataOutputStream);
                }
                channelOutputStream.close();
            }
            finally {
                IoUtils.safeClose((Closeable)channelOutputStream);
            }
            this.compatibleChannel = channel;
            this.latch.countDown();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    Channel getCompatibleChannel() {
        return this.compatibleChannel;
    }

    int getNegotiatedProtocolVersion() {
        return this.negotiatedVersion;
    }

    boolean failedCompatibility() {
        return this.compatibilityFailed;
    }
}

