/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.annotation.factory;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map map;
    private Class<?> annotationType;

    public AnnotationProxy(Class<?> annotationType, Map valueMap) {
        this.annotationType = annotationType;
        this.map = valueMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("equals".equals(name)) {
            return this.doEquals(proxy, args[0]);
        }
        if ("hashCode".equals(name)) {
            return this.doHashCode();
        }
        if ("toString".equals(name)) {
            return this.map.toString();
        }
        if ("annotationType".equals(name)) {
            return this.annotationType;
        }
        return this.map.get(name);
    }

    public Object getValue(String name) {
        return this.map.get(name);
    }

    private Object doEquals(Object proxy, Object obj) {
        if (obj == proxy) {
            return Boolean.TRUE;
        }
        if (obj == null) {
            return Boolean.FALSE;
        }
        Class<?>[] intfs = proxy.getClass().getInterfaces();
        if (!intfs[0].isAssignableFrom(obj.getClass())) {
            return Boolean.FALSE;
        }
        try {
            Proxy.getInvocationHandler(obj);
        }
        catch (Exception ex) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Object doHashCode() {
        return new Integer(((Object)this.map).hashCode());
    }

    public static Object createProxy(Map map, Class<?> annotation) throws Exception {
        AnnotationProxy proxyHandler = new AnnotationProxy(annotation, map);
        return Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (InvocationHandler)proxyHandler);
    }
}

