/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.FieldInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;

public class ReflectFieldInfoImpl
extends FieldInfoImpl {
    private static final long serialVersionUID = 2L;
    private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");
    protected transient Field field;

    public ReflectFieldInfoImpl() {
    }

    public ReflectFieldInfoImpl(AnnotationValue[] annotations, String name, TypeInfo type, int modifiers, ClassInfo declaring) {
        super(annotations, name, type, modifiers, declaring);
    }

    public void setField(Field field) {
        if (field != null) {
            this.accessCheck(Modifier.isPublic(field.getModifiers()));
        }
        this.field = field;
        if (!this.isPublic() && field != null) {
            this.setAccessible();
        }
    }

    public Field getField() {
        this.accessCheck();
        return this.field;
    }

    protected final void accessCheck() {
        this.accessCheck(this.isPublic());
    }

    protected final void accessCheck(boolean isPublic) {
        SecurityManager sm;
        if (!isPublic && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(accessCheck);
        }
    }

    public Object get(Object target) throws Throwable {
        this.accessCheck();
        return ReflectionUtils.getField(this.field, target);
    }

    public Object set(Object target, Object value) throws Throwable {
        this.accessCheck();
        return ReflectionUtils.setField(this.field, target, value);
    }

    private void readObject(ObjectInputStream oistream) throws IOException, ClassNotFoundException, NoSuchFieldException {
        oistream.defaultReadObject();
        this.setField(ReflectionUtils.findExactField(this.getDeclaringClass().getType(), this.name));
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectFieldInfoImpl.this.field.setAccessible(true);
            return null;
        }
    }
}

