/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

class SignatureKey {
    String name;
    String[] params;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    public SignatureKey(String name) {
        this.name = name;
    }

    public SignatureKey(String name, TypeInfo ... typeInfos) {
        this.name = name;
        if (typeInfos != null && typeInfos.length > 0) {
            this.params = new String[typeInfos.length];
            for (int i = 0; i < typeInfos.length; ++i) {
                this.params[i] = typeInfos[i].getName();
            }
        }
    }

    public SignatureKey(String name, String ... params) {
        this.name = name;
        if (params != null && params.length > 0) {
            this.params = params;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SignatureKey)) {
            return false;
        }
        SignatureKey other = (SignatureKey)obj;
        if (this.name == null && other.name != null) {
            return false;
        }
        if (this.name != null && other.name == null) {
            return false;
        }
        if (this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        if (this.params == null && other.params == null) {
            return true;
        }
        if (this.params == null && other.params != null) {
            return false;
        }
        if (this.params != null && other.params == null) {
            return false;
        }
        if (this.params.length != other.params.length) {
            return false;
        }
        for (int i = 0; i < this.params.length; ++i) {
            if (this.params[i].equals(other.params[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            JBossStringBuilder builder = new JBossStringBuilder();
            if (this.name != null) {
                builder.append(this.name);
            }
            if (this.params != null) {
                for (int i = 0; i < this.params.length; ++i) {
                    builder.append(this.params[i]);
                }
            }
            this.cachedHashCode = builder.toString().hashCode();
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.params == null) {
            return this.name + "[]";
        }
        return this.name + Arrays.asList(this.params);
    }
}

