/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.jboss.util.JBossObject;
import org.jboss.virtual.plugins.context.AbstractVirtualFileHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingHandler
extends AbstractVirtualFileHandler {
    private static final long serialVersionUID = 1L;
    private VirtualFileHandler delegate;

    public DelegatingHandler(VFSContext context, VirtualFileHandler parent, String name) {
        this(context, parent, name, null);
    }

    public DelegatingHandler(VFSContext context, VirtualFileHandler parent, String name, VirtualFileHandler delegate) {
        super(context, parent, name);
        this.delegate = delegate;
    }

    public void setDelegate(VirtualFileHandler handler) {
        this.delegate = handler;
    }

    public VirtualFileHandler getDelegate() {
        if (this.delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        return this.delegate;
    }

    @Override
    protected void setVfsUrl(URL vfsUrl) {
        if (this.delegate instanceof AbstractVirtualFileHandler) {
            ((AbstractVirtualFileHandler)this.delegate).setVfsUrl(vfsUrl);
        }
    }

    @Override
    public VirtualFileHandler getChild(String path) throws IOException {
        VirtualFileHandler child = this.getDelegate().getChild(path);
        if (this.getDelegate().equals(child)) {
            return this;
        }
        return child;
    }

    @Override
    public boolean removeChild(String path) throws IOException {
        throw new IOException("This method should never get called!");
    }

    @Override
    public List<VirtualFileHandler> getChildren(boolean ignoreErrors) throws IOException {
        return this.getDelegate().getChildren(ignoreErrors);
    }

    @Override
    public long getLastModified() throws IOException {
        return this.getDelegate().getLastModified();
    }

    @Override
    public long getSize() throws IOException {
        return this.getDelegate().getSize();
    }

    @Override
    public boolean isLeaf() throws IOException {
        return this.getDelegate().isLeaf();
    }

    @Override
    public boolean exists() throws IOException {
        return this.getDelegate().exists();
    }

    @Override
    public boolean isHidden() throws IOException {
        return this.getDelegate().isHidden();
    }

    @Override
    public boolean isNested() throws IOException {
        return this.getDelegate().isNested();
    }

    @Override
    public boolean delete(int gracePeriod) throws IOException {
        return this.getDelegate().delete(gracePeriod);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.getDelegate().openStream();
    }

    @Override
    public URI toURI() throws URISyntaxException {
        return this.getDelegate().toURI();
    }

    @Override
    public URL toURL() throws URISyntaxException, MalformedURLException {
        return this.getDelegate().toURL();
    }

    @Override
    protected void internalReplaceChild(VirtualFileHandler original, VirtualFileHandler replacement) {
        this.getDelegate().replaceChild(original, replacement);
    }

    @Override
    public URL toVfsUrl() throws MalformedURLException, URISyntaxException {
        return this.getDelegate().toVfsUrl();
    }

    @Override
    public int hashCode() {
        if (this.delegate != null) {
            return this.delegate.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualFileHandler)) {
            return false;
        }
        VirtualFileHandler vfh = (VirtualFileHandler)o;
        if (vfh instanceof DelegatingHandler) {
            DelegatingHandler handler = (DelegatingHandler)o;
            vfh = handler.getDelegate();
        }
        return JBossObject.equals((Object)this.delegate, (Object)vfh);
    }
}

