/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.vfs.protocol;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

class VirtualFileURLConnection
extends URLConnection {
    private final VirtualFile file;

    public VirtualFileURLConnection(URL url) throws IOException {
        super(url);
        this.file = VFS.getChild(VirtualFileURLConnection.toURI(url));
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public VirtualFile getContent() throws IOException {
        return this.file;
    }

    @Override
    public int getContentLength() {
        long size = this.file.getSize();
        return size > Integer.MAX_VALUE ? -1 : (int)size;
    }

    @Override
    public long getLastModified() {
        return this.file.getLastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.file.openStream();
    }

    @Override
    public Permission getPermission() throws IOException {
        String decodedPath = VirtualFileURLConnection.toURI(this.url).getPath();
        if (File.separatorChar != '/') {
            decodedPath = decodedPath.replace('/', File.separatorChar);
        }
        return new FilePermission(decodedPath, "read");
    }

    private static URI toURI(URL url) throws IOException {
        try {
            return VFSUtils.toURI(url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

