/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceBinding
extends ModelGroupBinding {
    private List<ParticleBinding> choices = Collections.emptyList();

    public ChoiceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return null;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        switch (this.choices.size()) {
            case 0: {
                this.choices = Collections.singletonList(particle);
                break;
            }
            case 1: {
                this.choices = new ArrayList<ParticleBinding>(this.choices);
            }
            default: {
                this.choices.add(particle);
            }
        }
        super.addParticle(particle);
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        return Collections.unmodifiableCollection(this.choices);
    }

    @Override
    public ModelGroupBinding.Cursor newCursor(ParticleBinding particle) {
        return new ModelGroupBinding.Cursor(particle){
            private int pos;
            private ElementBinding element;
            private boolean wildcardContent;
            {
                this.pos = -1;
            }

            @Override
            public ParticleBinding getCurrentParticle() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return (ParticleBinding)ChoiceBinding.this.choices.get(this.pos);
            }

            @Override
            public ElementBinding getElement() {
                if (this.pos < 0) {
                    throw new JBossXBRuntimeException("The cursor has not been positioned yet! startElement should be called.");
                }
                return this.element;
            }

            @Override
            public boolean isPositioned() {
                return this.pos != -1;
            }

            @Override
            public void endElement(QName qName) {
                if (this.element == null || !this.element.getQName().equals(qName)) {
                    throw new JBossXBRuntimeException("Failed to process endElement for " + qName + " since the current element is " + (this.element == null ? "null" : this.element.getQName().toString()));
                }
                if (this.trace) {
                    ChoiceBinding.this.log.trace((Object)("endElement " + qName + " in " + this.getModelGroup()));
                }
            }

            @Override
            public boolean isWildcardContent() {
                return this.wildcardContent;
            }

            @Override
            protected List<ModelGroupBinding.Cursor> startElement(QName qName, Attributes atts, Set<ModelGroupBinding.Cursor> passedGroups, List<ModelGroupBinding.Cursor> groupStack, boolean required) {
                ParticleBinding particle;
                if (this.trace) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("startElement ").append(qName).append(" in ").append(this.toString());
                    ChoiceBinding.this.log.trace((Object)sb.toString());
                }
                this.wildcardContent = false;
                int i = this.pos;
                if (this.pos >= 0 && ((particle = this.getCurrentParticle()).getMaxOccursUnbounded() || this.occurence < particle.getMinOccurs() || this.occurence < particle.getMaxOccurs())) {
                    --i;
                }
                while (i < ChoiceBinding.this.choices.size() - 1) {
                    particle = (ParticleBinding)ChoiceBinding.this.choices.get(++i);
                    TermBinding item = particle.getTerm();
                    if (item instanceof ElementBinding) {
                        ElementBinding element = (ElementBinding)item;
                        if (!qName.equals(element.getQName())) continue;
                        if (this.pos == i) {
                            ++this.occurence;
                        } else {
                            this.pos = i;
                            this.occurence = 1;
                        }
                        groupStack = this.addItem(groupStack, this);
                        this.element = element;
                        if (!this.trace) break;
                        ChoiceBinding.this.log.trace((Object)("found " + qName + " in " + this.getModelGroup()));
                        break;
                    }
                    if (item instanceof ModelGroupBinding) {
                        boolean isRequired;
                        ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                        if (passedGroups.contains(modelGroup)) continue;
                        switch (passedGroups.size()) {
                            case 0: {
                                passedGroups = Collections.singleton(this);
                                break;
                            }
                            case 1: {
                                passedGroups = new HashSet<ModelGroupBinding.Cursor>(passedGroups);
                            }
                            default: {
                                passedGroups.add(this);
                            }
                        }
                        int groupStackSize = groupStack.size();
                        boolean bl = isRequired = this.occurence == 0 ? false : particle.isRequired(this.occurence);
                        groupStack = modelGroup.newCursor(particle).startElement(qName, atts, passedGroups, groupStack, isRequired);
                        if (groupStackSize == groupStack.size()) continue;
                        if (this.pos != i) {
                            this.pos = i;
                            this.occurence = 1;
                        } else {
                            ++this.occurence;
                        }
                        groupStack = this.addItem(groupStack, this);
                        this.element = null;
                        break;
                    }
                    if (!(item instanceof WildcardBinding)) continue;
                    WildcardBinding wildcard = (WildcardBinding)item;
                    this.element = wildcard.getElement(qName, atts);
                    if (this.element == null) continue;
                    if (this.pos != i) {
                        this.pos = i;
                        this.occurence = 1;
                    } else {
                        ++this.occurence;
                    }
                    groupStack = this.addItem(groupStack, this);
                    this.wildcardContent = true;
                    if (!this.trace) break;
                    ChoiceBinding.this.log.trace((Object)(qName + " is wildcard content"));
                    break;
                }
                if (this.trace) {
                    if (i == ChoiceBinding.this.choices.size()) {
                        ChoiceBinding.this.log.trace((Object)(qName + " not found in " + this.getModelGroup()));
                    } else {
                        ChoiceBinding.this.log.trace((Object)("leaving " + this.getModelGroup() + " i=" + i + ", pos=" + this.pos));
                    }
                }
                return groupStack;
            }

            @Override
            protected ElementBinding getElement(QName qName, Attributes atts, Set<ModelGroupBinding.Cursor> passedGroups, boolean ignoreWildcards) {
                return this.getElement(ChoiceBinding.this.choices, qName, atts, passedGroups, ignoreWildcards);
            }
        };
    }

    @Override
    protected boolean mayStartWith(QName qName, Set<ModelGroupBinding> set) {
        boolean result = false;
        for (int i = 0; i < this.choices.size(); ++i) {
            ParticleBinding particle = this.choices.get(i);
            TermBinding item = particle.getTerm();
            if (item instanceof ElementBinding) {
                ElementBinding element = (ElementBinding)item;
                if (!qName.equals(element.getQName())) continue;
                result = true;
                break;
            }
            if (item instanceof ModelGroupBinding) {
                ModelGroupBinding modelGroup = (ModelGroupBinding)item;
                if (set.contains(modelGroup)) continue;
                switch (set.size()) {
                    case 0: {
                        set = Collections.singleton(this);
                        break;
                    }
                    case 1: {
                        set = new HashSet<ModelGroupBinding>(set);
                    }
                    default: {
                        set.add(this);
                    }
                }
                result = modelGroup.mayStartWith(qName, set);
                if (!result) continue;
                break;
            }
            throw new JBossXBRuntimeException("Unexpected item type in model group: " + item);
        }
        return result;
    }

    @Override
    public String getGroupType() {
        return "choice";
    }
}

