/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.position.NonElementPosition;
import org.jboss.xb.binding.sunday.unmarshalling.position.Position;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnorderedSequenceBinding
extends ModelGroupBinding {
    private Map<QName, ParticleBinding> elementParticles = Collections.emptyMap();
    private List<ParticleBinding> groupParticles = Collections.emptyList();
    private List<ParticleBinding> wildcardParticles = Collections.emptyList();
    private ElementBinding arrayItem;
    private List<ParticleBinding> allParticles = null;

    public UnorderedSequenceBinding(SchemaBinding schema) {
        super(schema);
    }

    @Override
    public ElementBinding getArrayItem() {
        return this.arrayItem;
    }

    @Override
    public void addParticle(ParticleBinding particle) {
        TermBinding term = particle.getTerm();
        if (term.isElement()) {
            if (this.elementParticles.isEmpty()) {
                this.elementParticles = new HashMap<QName, ParticleBinding>();
            }
            this.elementParticles.put(((ElementBinding)term).getQName(), particle);
        } else if (term.isModelGroup()) {
            if (this.groupParticles.isEmpty()) {
                this.groupParticles = new ArrayList<ParticleBinding>();
            }
            this.groupParticles.add(particle);
        } else if (term.isWildcard()) {
            if (this.wildcardParticles.isEmpty()) {
                this.wildcardParticles = new ArrayList<ParticleBinding>();
            }
            this.wildcardParticles.add(particle);
        } else {
            throw new JBossXBRuntimeException("Unexpected term type: " + term);
        }
        super.addParticle(particle);
        this.allParticles = null;
    }

    @Override
    public Collection<ParticleBinding> getParticles() {
        if (this.allParticles == null) {
            this.allParticles = new ArrayList<ParticleBinding>(this.elementParticles.size() + this.groupParticles.size() + this.wildcardParticles.size());
            this.allParticles.addAll(this.elementParticles.values());
            this.allParticles.addAll(this.groupParticles);
            this.allParticles.addAll(this.wildcardParticles);
        }
        return this.allParticles;
    }

    @Override
    public Position newPosition(QName qName, Attributes attrs, ParticleBinding seqParticle) {
        Position next;
        ParticleBinding currentParticle = this.elementParticles.get(qName);
        if (currentParticle != null) {
            return new UnorderedSequencePosition(qName, seqParticle, currentParticle.getTerm().newPosition(qName, attrs, currentParticle));
        }
        for (ParticleBinding particle : this.groupParticles) {
            next = particle.getTerm().newPosition(qName, attrs, particle);
            if (next == null) continue;
            return new UnorderedSequencePosition(qName, seqParticle, next);
        }
        for (ParticleBinding particle : this.wildcardParticles) {
            next = particle.getTerm().newPosition(qName, attrs, particle);
            if (next == null) continue;
            return new UnorderedSequencePosition(qName, seqParticle, next);
        }
        return null;
    }

    @Override
    public String getGroupType() {
        return "unordered_sequence";
    }

    private final class UnorderedSequencePosition
    extends NonElementPosition {
        private UnorderedSequencePosition(QName name, ParticleBinding particle, Position next) {
            super(name, particle, next);
        }

        public Position nextPosition(QName qName, Attributes atts) {
            ParticleBinding element;
            if (trace) {
                StringBuffer sb = new StringBuffer();
                sb.append("startElement ").append(qName).append(" in ").append(UnorderedSequenceBinding.this.toString());
                log.trace((Object)sb.toString());
            }
            if ((element = (ParticleBinding)UnorderedSequenceBinding.this.elementParticles.get(qName)) != null) {
                this.next = element.getTerm().newPosition(qName, atts, element);
                this.next.setPrevious(this);
                if (trace) {
                    log.trace((Object)("found " + qName + " in " + UnorderedSequenceBinding.this));
                }
                return this;
            }
            for (ParticleBinding particle : UnorderedSequenceBinding.this.groupParticles) {
                this.next = particle.getTerm().newPosition(qName, atts, particle);
                if (this.next == null) continue;
                this.next.setPrevious(this);
                return this;
            }
            for (ParticleBinding particle : UnorderedSequenceBinding.this.wildcardParticles) {
                this.next = particle.getTerm().newPosition(qName, atts, particle);
                if (this.next == null) continue;
                this.next.setPrevious(this);
                return this;
            }
            this.nextNotFound();
            return null;
        }
    }
}

