/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook;

import java.util.Locale;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.profile.ProfilerImpl;
import org.jboss.jdocbook.render.Renderer;
import org.jboss.jdocbook.render.RendererImpl;
import org.jboss.jdocbook.render.XslFoGenerator;
import org.jboss.jdocbook.render.XslFoGeneratorImpl;
import org.jboss.jdocbook.translate.PoSynchronizer;
import org.jboss.jdocbook.translate.PoSynchronizerImpl;
import org.jboss.jdocbook.translate.PotSynchronizer;
import org.jboss.jdocbook.translate.PotSynchronizerImpl;
import org.jboss.jdocbook.translate.Translator;
import org.jboss.jdocbook.translate.TranslatorImpl;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.xslt.TransformerBuilder;
import org.jboss.jdocbook.xslt.TransformerBuilderImpl;

public class JDocBookComponentRegistry {
    private final Environment environment;
    private final Configuration configuration;
    private final TransformerBuilderImpl transformerBuilder;
    private final TranslatorImpl translator;
    private final ProfilerImpl profiler;
    private final RendererImpl renderer;
    private final XslFoGeneratorImpl xslFoGenerator;
    private final PotSynchronizerImpl potSynchronizer;
    private final PoSynchronizerImpl poSynchronizer;

    public JDocBookComponentRegistry(Environment environment, Configuration configuration) {
        this.environment = environment;
        this.configuration = configuration;
        this.transformerBuilder = new TransformerBuilderImpl(this);
        this.translator = new TranslatorImpl(this);
        this.profiler = new ProfilerImpl(this);
        this.renderer = new RendererImpl(this);
        this.xslFoGenerator = new XslFoGeneratorImpl(this);
        this.potSynchronizer = new PotSynchronizerImpl(this);
        this.poSynchronizer = new PoSynchronizerImpl(this);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TransformerBuilder getTransformerBuilder() {
        return this.transformerBuilder;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public XslFoGenerator getXslFoGenerator() {
        return this.xslFoGenerator;
    }

    public PotSynchronizer getPotSynchronizer() {
        return this.potSynchronizer;
    }

    public PoSynchronizer getPoSynchronizer() {
        return this.poSynchronizer;
    }

    public String toLanguageString(Locale language) {
        return TranslationUtils.render(language, this.configuration.getLocaleSeparator());
    }
}

