/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.profile;

import java.io.File;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jdocbook.Configuration;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.profile.Profiler;
import org.jboss.jdocbook.profile.ProfilingSource;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.xslt.EntityResolverChain;
import org.jboss.jdocbook.xslt.LocalDocBookEntityResolver;
import org.jboss.jdocbook.xslt.TransformerBuilder;
import org.jboss.jdocbook.xslt.XIncludeEntityResolver;
import org.jboss.jdocbook.xslt.XSLTException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public class ProfilerImpl
implements Profiler {
    private static final Logger log = LoggerFactory.getLogger(ProfilerImpl.class);
    private final JDocBookComponentRegistry componentRegistry;
    private final EntityResolverChain entityResolver;

    public ProfilerImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
        this.entityResolver = new EntityResolverChain((EntityResolver)componentRegistry.getTransformerBuilder().getCatalogResolver());
        this.entityResolver.addEntityResolver(new LocalDocBookEntityResolver());
        this.entityResolver.addEntityResolver(new XIncludeEntityResolver(componentRegistry));
    }

    protected Environment environment() {
        return this.componentRegistry.getEnvironment();
    }

    private Configuration configuration() {
        return this.componentRegistry.getConfiguration();
    }

    private TransformerBuilder transformerBuilder() {
        return this.componentRegistry.getTransformerBuilder();
    }

    public void profile(ProfilingSource profilingSource) {
        try {
            boolean created;
            File targetFile = profilingSource.resolveProfiledDocumentFile();
            log.info("applying DocBook profiling [" + targetFile.getAbsolutePath() + "]");
            if (!targetFile.getParentFile().exists() && !(created = targetFile.getParentFile().mkdirs())) {
                log.info("Unable to create parent directory " + targetFile.getAbsolutePath());
            }
            String languageString = this.render(profilingSource.getLanguage());
            Transformer xslt = this.transformerBuilder().buildStandardTransformer("profiling/profile.xsl");
            xslt.setParameter("l10n.gentext.language", languageString);
            String profilingAttributeName = this.configuration().getProfiling().getAttributeName();
            if (profilingAttributeName == null || "lang".equals(profilingAttributeName)) {
                xslt.setParameter("profile.attribute", "lang");
                xslt.setParameter("profile.lang", languageString);
            } else {
                xslt.setParameter("profile.attribute", profilingAttributeName);
                xslt.setParameter("profile.value", this.configuration().getProfiling().getAttributeValue());
            }
            xslt.transform(this.buildSource(profilingSource.resolveDocumentFile()), this.buildResult(targetFile));
        }
        catch (TransformerException e) {
            throw new XSLTException("error performing translation [" + e.getLocationAsString() + "] : " + e.getMessage(), e);
        }
    }

    private Source buildSource(File sourceFile) throws XSLTException {
        return FileUtils.createSAXSource(sourceFile, this.entityResolver, this.configuration().getValueInjections());
    }

    protected Result buildResult(File targetFile) throws XSLTException {
        return new StreamResult(targetFile);
    }

    private String render(Locale language) {
        return TranslationUtils.render(language, this.configuration().getLocaleSeparator());
    }
}

