/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render;

import java.io.File;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.StandardDocBookFormatMetadata;
import org.jboss.jdocbook.util.TargetNamingStrategy;
import org.jboss.jdocbook.xslt.FormatPlan;

public class FormatPlanBuilder {
    public static FormatPlan buildFormatPlan(FormatOptions formatOptions) {
        StandardDocBookFormatMetadata.FormatMetadata formatMetadata = StandardDocBookFormatMetadata.getFormatMetadata(formatOptions.getName());
        if (formatMetadata == null) {
            throw new RenderingException("Unknown format name " + formatOptions.getName());
        }
        return new FormatPlanImpl(formatMetadata, formatOptions);
    }

    private static class FormatPlanImpl
    implements FormatPlan {
        private final StandardDocBookFormatMetadata.FormatMetadata formatMetadata;
        private final FormatOptions formatOptions;
        private final TargetNamingStrategyImpl targetNamingStrategy = new TargetNamingStrategyImpl();

        private FormatPlanImpl(StandardDocBookFormatMetadata.FormatMetadata formatMetadata, FormatOptions formatOptions) {
            this.formatMetadata = formatMetadata;
            this.formatOptions = formatOptions;
        }

        public String getName() {
            return this.formatMetadata.getName();
        }

        public String getStylesheetResource() {
            return this.formatOptions.getStylesheetResource() != null ? this.formatOptions.getStylesheetResource() : this.formatMetadata.getStylesheetResource();
        }

        public String getCorrespondingDocBookStylesheetResource() {
            return this.formatMetadata.getStylesheetResource();
        }

        public TargetNamingStrategy getTargetNamingStrategy() {
            return this.targetNamingStrategy;
        }

        public boolean requiresSettingImagePath() {
            return this.formatMetadata.requiresImagePathSetting();
        }

        public boolean requiresImageCopying() {
            return this.formatMetadata.requiresImageCopying();
        }

        public boolean doesChunking() {
            return this.formatMetadata.doesChunking();
        }

        private class TargetNamingStrategyImpl
        implements TargetNamingStrategy {
            private TargetNamingStrategyImpl() {
            }

            public String determineTargetFileName(File source) {
                return FormatPlanImpl.this.formatOptions.getTargetFinalName() != null ? FormatPlanImpl.this.formatOptions.getTargetFinalName() : FileUtils.basename((String)source.getAbsolutePath()) + FormatPlanImpl.this.formatMetadata.getFileExtension();
            }
        }
    }
}

