/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.render;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.render.FormatOptions;
import org.jboss.jdocbook.render.FormatPlanBuilder;
import org.jboss.jdocbook.render.RenderingException;
import org.jboss.jdocbook.render.RenderingSource;
import org.jboss.jdocbook.render.XslFoGenerator;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.StandardDocBookFormatMetadata;
import org.jboss.jdocbook.util.TranslationUtils;
import org.jboss.jdocbook.xslt.FormatPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XslFoGeneratorImpl
implements XslFoGenerator {
    private static final Logger log = LoggerFactory.getLogger(XslFoGeneratorImpl.class);
    private final JDocBookComponentRegistry componentRegistry;

    public XslFoGeneratorImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateXslFo(RenderingSource source, FormatOptions formatOptions) {
        boolean createFile;
        boolean created;
        FormatPlan formatPlan = FormatPlanBuilder.buildFormatPlan(formatOptions);
        Transformer transformer = this.buildXslFoTransformer(formatPlan);
        String sourceFileBaseName = FileUtils.basename((String)source.resolveSourceDocument().getAbsolutePath());
        File fo = new File(source.getXslFoDirectory(), sourceFileBaseName + ".fo");
        String lang = TranslationUtils.render(source.getLanguage(), this.componentRegistry.getConfiguration().getLocaleSeparator());
        transformer.setParameter("l10n.gentext.language", lang);
        if (!fo.getParentFile().exists()) {
            created = fo.getParentFile().mkdirs();
            if (!created) {
                throw new RenderingException("Unable to create FO file directory");
            }
            createFile = true;
        } else {
            boolean bl = createFile = !fo.exists();
        }
        if (createFile) {
            try {
                created = fo.createNewFile();
                if (!created) {
                    log.info("File system indicated problem creating FO file {}", (Object)fo);
                }
            }
            catch (IOException e) {
                throw new RenderingException("Unable to create FO file " + fo.toString());
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(fo);
            try {
                File sourceFile = source.resolveSourceDocument();
                StreamSource sourceStream = new StreamSource(sourceFile);
                StreamResult resultStream = new StreamResult(out);
                try {
                    transformer.transform(sourceStream, resultStream);
                }
                catch (TransformerException e) {
                    throw new RenderingException("Unable to apply FO transformation", e);
                }
            }
            finally {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    log.info("Unable to close output stream {}", (Object)fo);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new RenderingException("Unable to open output stream to FO file", e);
        }
    }

    private Transformer buildXslFoTransformer(FormatPlan formatPlan) {
        URL transformationStylesheet = formatPlan.getStylesheetResource() == null ? this.componentRegistry.getEnvironment().getResourceDelegate().requireResource(StandardDocBookFormatMetadata.PDF.getStylesheetResource()) : this.componentRegistry.getEnvironment().getResourceDelegate().requireResource(formatPlan.getStylesheetResource());
        return this.componentRegistry.getTransformerBuilder().buildTransformer(formatPlan, transformationStylesheet);
    }
}

