/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.translate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.JDocBookProcessException;
import org.jboss.jdocbook.translate.PotSynchronizer;
import org.jboss.jdocbook.util.FileUtils;
import org.jboss.jdocbook.util.TranslationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotSynchronizerImpl
implements PotSynchronizer {
    private static final Logger log = LoggerFactory.getLogger(PotSynchronizerImpl.class);
    private final JDocBookComponentRegistry componentRegistry;

    public PotSynchronizerImpl(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void synchronizePot() throws JDocBookProcessException {
        File basedir = this.componentRegistry.getEnvironment().getMasterLanguageDescriptor().getBaseSourceDirectory();
        File potDirectory = this.componentRegistry.getEnvironment().getMasterLanguageDescriptor().getPotDirectory();
        for (File sourceFile : this.componentRegistry.getEnvironment().getMasterLanguageDescriptor().getDocumentFiles()) {
            File relativeTranslationDir;
            String relativity = FileUtils.determineRelativity(sourceFile, basedir);
            File file = relativeTranslationDir = relativity == null ? potDirectory : new File(potDirectory, relativity);
            if (!FileUtils.isXMLFile(sourceFile)) continue;
            String poFileName = TranslationUtils.determinePotFileName(sourceFile);
            File potFile = new File(relativeTranslationDir, poFileName);
            this.updatePortableObjectTemplate(sourceFile, potFile);
        }
    }

    private void updatePortableObjectTemplate(File masterFile, File potFile) {
        boolean created;
        if (!masterFile.exists()) {
            log.trace("skipping POT update; source file did not exist : {0}", (Object)masterFile);
            return;
        }
        if (potFile.exists() && potFile.lastModified() >= masterFile.lastModified()) {
            log.trace("skipping POT update; up-to-date : {0}", (Object)potFile);
            return;
        }
        if (!potFile.getParentFile().exists() && !(created = potFile.getParentFile().mkdirs())) {
            log.info("Unable to generate POT directory {}" + FileUtils.resolveFullPathName(potFile.getParentFile()));
        }
        this.executeXml2pot(masterFile, potFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeXml2pot(File masterFile, File potFile) {
        CommandLine commandLine = CommandLine.parse((String)"xml2pot");
        commandLine.addArgument(FileUtils.resolveFullPathName(masterFile));
        DefaultExecutor executor = new DefaultExecutor();
        try {
            FileOutputStream xmlStream = new FileOutputStream(potFile);
            PumpStreamHandler streamDirector = new PumpStreamHandler((OutputStream)xmlStream, (OutputStream)System.err);
            executor.setStreamHandler((ExecuteStreamHandler)streamDirector);
            try {
                log.trace("updating POT file {0}", (Object)potFile);
                executor.execute(commandLine);
            }
            finally {
                try {
                    xmlStream.flush();
                    xmlStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (IOException e) {
            throw new JDocBookProcessException("unable to open output stream for POT file [" + potFile + "]");
        }
    }
}

