/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.jboss.jdocbook.JDocBookProcessException;

public class ConsoleRedirectionHandler {
    private final File redirectionFile;
    private PrintStream redirectionStream;
    private PrintStream sysout;
    private PrintStream syserr;

    public ConsoleRedirectionHandler(File redirectionFile) {
        this.redirectionFile = redirectionFile;
    }

    public void start() {
        System.out.println("redirecting output to file [" + this.redirectionFile.getAbsolutePath() + "]");
        if (!this.redirectionFile.exists()) {
            this.redirectionFile.getParentFile().mkdirs();
            try {
                this.redirectionFile.createNewFile();
            }
            catch (IOException e) {
                throw new JDocBookProcessException("Unable to create console redirection file [" + this.redirectionFile.getAbsolutePath() + "]", e);
            }
        }
        try {
            this.redirectionStream = new PrintStream(new FileOutputStream(this.redirectionFile));
        }
        catch (FileNotFoundException e) {
            throw new JDocBookProcessException("Unable to open console redirect file for output", e);
        }
        this.sysout = System.out;
        this.syserr = System.err;
        System.setOut(this.redirectionStream);
        System.setErr(this.redirectionStream);
    }

    public void stop() {
        System.setOut(this.sysout);
        System.setErr(this.syserr);
        this.redirectionStream.flush();
        this.redirectionStream.close();
    }
}

