/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.util;

import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jboss.jdocbook.util.FileUtils;

public class TranslationUtils {
    public static boolean isPotFile(File file) {
        return "pot".equals(FileUtils.getExtension((String)file.getName()));
    }

    public static String determinePotFileName(File source) {
        return FileUtils.removeExtension((String)source.getName()) + ".pot";
    }

    public static String determinePoFileName(File template) {
        return FileUtils.removeExtension((String)template.getName()) + ".po";
    }

    public static Locale parse(String locale) {
        return TranslationUtils.parse(locale, '-');
    }

    public static Locale parse(String locale, char sep) {
        StringTokenizer tokens = new StringTokenizer(locale, "" + sep);
        int tokencount = tokens.countTokens();
        switch (tokencount) {
            case 3: {
                return new Locale(tokens.nextToken(), tokens.nextToken(), tokens.nextToken());
            }
            case 2: {
                return new Locale(tokens.nextToken(), tokens.nextToken());
            }
            case 1: {
                return new Locale(tokens.nextToken());
            }
        }
        return new Locale("tbd");
    }

    public static String render(Locale locale, char sep) {
        boolean l = locale.getLanguage().length() != 0;
        boolean c = locale.getCountry().length() != 0;
        boolean v = locale.getVariant().length() != 0;
        StringBuffer result = new StringBuffer(locale.getLanguage());
        if (c || l && v) {
            result.append(sep).append(locale.getCountry());
        }
        if (v && (l || c)) {
            result.append(sep).append(locale.getVariant());
        }
        return result.toString();
    }
}

